/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.utils;

import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQCommonProperties;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.RPCHook;
import org.springframework.util.StringUtils;

public final class RocketMQUtils {
    private static final String SQL = "sql:";

    private RocketMQUtils() {
    }

    public static <T extends RocketMQCommonProperties> T mergeRocketMQProperties(RocketMQBinderConfigurationProperties binderConfigurationProperties, T mqProperties) {
        if (null == binderConfigurationProperties || mqProperties == null) {
            return mqProperties;
        }
        if (StringUtils.isEmpty((Object)mqProperties.getNameServer())) {
            mqProperties.setNameServer(binderConfigurationProperties.getNameServer());
        }
        if (StringUtils.isEmpty((Object)mqProperties.getSecretKey())) {
            mqProperties.setSecretKey(binderConfigurationProperties.getSecretKey());
        }
        if (StringUtils.isEmpty((Object)mqProperties.getAccessKey())) {
            mqProperties.setAccessKey(binderConfigurationProperties.getAccessKey());
        }
        if (StringUtils.isEmpty((Object)mqProperties.getAccessChannel())) {
            mqProperties.setAccessChannel(binderConfigurationProperties.getAccessChannel());
        }
        if (StringUtils.isEmpty((Object)mqProperties.getNamespace())) {
            mqProperties.setNamespace(binderConfigurationProperties.getNamespace());
        }
        if (StringUtils.isEmpty((Object)mqProperties.getGroup())) {
            mqProperties.setGroup(binderConfigurationProperties.getGroup());
        }
        if (StringUtils.isEmpty((Object)mqProperties.getCustomizedTraceTopic())) {
            mqProperties.setCustomizedTraceTopic(binderConfigurationProperties.getCustomizedTraceTopic());
        }
        if (StringUtils.isEmpty((Object)mqProperties.getUnitName())) {
            mqProperties.setUnitName(binderConfigurationProperties.getUnitName());
        }
        mqProperties.setNameServer(RocketMQUtils.getNameServerStr(mqProperties.getNameServer()));
        return mqProperties;
    }

    public static String getInstanceName(RPCHook rpcHook, String identify) {
        String separator = "|";
        StringBuilder instanceName = new StringBuilder();
        if (null != rpcHook) {
            SessionCredentials sessionCredentials = ((AclClientRPCHook)rpcHook).getSessionCredentials();
            instanceName.append(sessionCredentials.getAccessKey()).append(separator).append(sessionCredentials.getSecretKey()).append(separator);
        }
        instanceName.append(identify).append(separator).append(UtilAll.getPid());
        return instanceName.toString();
    }

    public static String getNameServerStr(String nameServer) {
        if (StringUtils.isEmpty((Object)nameServer)) {
            return "127.0.0.1:9876";
        }
        return nameServer.replaceAll(",", ";");
    }

    public static MessageSelector getMessageSelector(String expression) {
        if (StringUtils.hasText((String)expression) && expression.startsWith(SQL)) {
            return MessageSelector.bySql((String)expression.replaceFirst(SQL, ""));
        }
        return MessageSelector.byTag((String)expression);
    }

    public static String anonymousGroup(String destination) {
        return "anonymous_" + destination;
    }
}

