/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.utils;

import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQBinderConfigurationProperties;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQCommonProperties;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.MessageSelector;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.remoting.RPCHook;

public final class RocketMQUtils {
    private static final String SQL = "sql:";

    private RocketMQUtils() {
    }

    public static <T extends RocketMQCommonProperties> T mergeRocketMQProperties(RocketMQBinderConfigurationProperties binderConfigurationProperties, T mqProperties) {
        if (null == binderConfigurationProperties || mqProperties == null) {
            return mqProperties;
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getNameServer())) {
            mqProperties.setNameServer(binderConfigurationProperties.getNameServer());
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getSecretKey())) {
            mqProperties.setSecretKey(binderConfigurationProperties.getSecretKey());
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getAccessKey())) {
            mqProperties.setAccessKey(binderConfigurationProperties.getAccessKey());
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getAccessChannel())) {
            mqProperties.setAccessChannel(binderConfigurationProperties.getAccessChannel());
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getNamespace())) {
            mqProperties.setNamespace(binderConfigurationProperties.getNamespace());
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getGroup())) {
            mqProperties.setGroup(binderConfigurationProperties.getGroup());
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getCustomizedTraceTopic())) {
            mqProperties.setCustomizedTraceTopic(binderConfigurationProperties.getCustomizedTraceTopic());
        }
        if (StringUtils.isEmpty((CharSequence)mqProperties.getUnitName())) {
            mqProperties.setUnitName(binderConfigurationProperties.getUnitName());
        }
        mqProperties.setNameServer(RocketMQUtils.getNameServerStr(mqProperties.getNameServer()));
        return mqProperties;
    }

    public static String getInstanceName(RPCHook rpcHook, String identify) {
        String separator = "|";
        StringBuilder instanceName = new StringBuilder();
        if (null != rpcHook) {
            SessionCredentials sessionCredentials = ((AclClientRPCHook)rpcHook).getSessionCredentials();
            instanceName.append(sessionCredentials.getAccessKey()).append(separator);
        }
        instanceName.append(identify).append(separator).append(UtilAll.getPid()).append(separator).append(Long.toString(System.nanoTime(), 36));
        return instanceName.toString();
    }

    public static String getNameServerStr(String nameServer) {
        if (StringUtils.isEmpty((CharSequence)nameServer)) {
            return "127.0.0.1:9876";
        }
        return nameServer.replaceAll(",", ";");
    }

    public static MessageSelector getMessageSelector(String expression) {
        if (StringUtils.isNotBlank((CharSequence)expression) && expression.startsWith(SQL)) {
            return MessageSelector.bySql((String)expression.replaceFirst(SQL, ""));
        }
        return MessageSelector.byTag((String)expression);
    }

    public static String anonymousGroup(String destination) {
        return "anonymous_" + destination;
    }
}

