/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.integration.inbound;

import com.alibaba.cloud.stream.binder.rocketmq.custom.RocketMQBeanContainerCache;
import com.alibaba.cloud.stream.binder.rocketmq.properties.RocketMQConsumerProperties;
import com.alibaba.cloud.stream.binder.rocketmq.utils.RocketMQUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.common.protocol.NamespaceUtil;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.RPCHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class RocketMQConsumerFactory {
    private static final Logger log = LoggerFactory.getLogger(RocketMQConsumerFactory.class);

    private RocketMQConsumerFactory() {
    }

    public static DefaultMQPushConsumer initPushConsumer(ExtendedConsumerProperties<RocketMQConsumerProperties> extendedConsumerProperties) {
        RocketMQConsumerProperties consumerProperties = (RocketMQConsumerProperties)extendedConsumerProperties.getExtension();
        Assert.notNull((Object)consumerProperties.getGroup(), (String)"Property 'group' is required - consumerGroup");
        Assert.notNull((Object)consumerProperties.getNameServer(), (String)"Property 'nameServer' is required");
        AllocateMessageQueueStrategy allocateMessageQueueStrategy = (AllocateMessageQueueStrategy)RocketMQBeanContainerCache.getBean(consumerProperties.getAllocateMessageQueueStrategy(), AllocateMessageQueueStrategy.class, new AllocateMessageQueueAveragely());
        AclClientRPCHook rpcHook = null;
        if (StringUtils.hasLength((String)consumerProperties.getAccessKey()) && StringUtils.hasLength((String)consumerProperties.getSecretKey())) {
            rpcHook = new AclClientRPCHook(new SessionCredentials(consumerProperties.getAccessKey(), consumerProperties.getSecretKey()));
        }
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(consumerProperties.getGroup(), rpcHook, allocateMessageQueueStrategy, consumerProperties.getEnableMsgTrace(), consumerProperties.getCustomizedTraceTopic());
        consumer.setVipChannelEnabled(null == rpcHook && consumerProperties.getVipChannelEnabled());
        consumer.setInstanceName(RocketMQUtils.getInstanceName((RPCHook)rpcHook, consumerProperties.getGroup()));
        consumer.setNamespace(consumerProperties.getNamespace());
        consumer.setNamesrvAddr(consumerProperties.getNameServer());
        consumer.setMessageModel(RocketMQConsumerFactory.getMessageModel(consumerProperties.getMessageModel()));
        consumer.setUseTLS(consumerProperties.getUseTLS());
        consumer.setPullTimeDelayMillsWhenException(consumerProperties.getPullTimeDelayMillsWhenException());
        consumer.setPullBatchSize(consumerProperties.getPullBatchSize());
        consumer.setConsumeFromWhere(consumerProperties.getConsumeFromWhere());
        consumer.setHeartbeatBrokerInterval(consumerProperties.getHeartbeatBrokerInterval());
        consumer.setPersistConsumerOffsetInterval(consumerProperties.getPersistConsumerOffsetInterval());
        consumer.setPullInterval(consumerProperties.getPush().getPullInterval());
        consumer.setConsumeThreadMin(extendedConsumerProperties.getConcurrency());
        consumer.setConsumeThreadMax(extendedConsumerProperties.getConcurrency());
        consumer.setUnitName(consumerProperties.getUnitName());
        return consumer;
    }

    public static DefaultLitePullConsumer initPullConsumer(String topic, ExtendedConsumerProperties<RocketMQConsumerProperties> extendedConsumerProperties) {
        boolean anonymous;
        RocketMQConsumerProperties consumerProperties = (RocketMQConsumerProperties)extendedConsumerProperties.getExtension();
        boolean bl = anonymous = !StringUtils.hasLength((String)consumerProperties.getGroup());
        if (anonymous && NamespaceUtil.isDLQTopic((String)topic)) {
            throw new RuntimeException("group must be configured for DLQ" + topic);
        }
        if (anonymous) {
            consumerProperties.setGroup(RocketMQUtils.anonymousGroup(topic));
        }
        Assert.notNull((Object)consumerProperties.getNameServer(), (String)"Property 'nameServer' is required");
        AllocateMessageQueueStrategy allocateMessageQueueStrategy = RocketMQBeanContainerCache.getBean(consumerProperties.getAllocateMessageQueueStrategy(), AllocateMessageQueueStrategy.class);
        AclClientRPCHook rpcHook = null;
        if (StringUtils.hasLength((String)consumerProperties.getAccessKey()) && StringUtils.hasLength((String)consumerProperties.getSecretKey())) {
            rpcHook = new AclClientRPCHook(new SessionCredentials(consumerProperties.getAccessKey(), consumerProperties.getSecretKey()));
        }
        DefaultLitePullConsumer consumer = new DefaultLitePullConsumer(consumerProperties.getNamespace(), consumerProperties.getGroup(), rpcHook);
        consumer.setVipChannelEnabled(null == rpcHook && consumerProperties.getVipChannelEnabled());
        consumer.setInstanceName(RocketMQUtils.getInstanceName((RPCHook)rpcHook, consumerProperties.getGroup()));
        if (null != allocateMessageQueueStrategy) {
            consumer.setAllocateMessageQueueStrategy(allocateMessageQueueStrategy);
        }
        consumer.setNamesrvAddr(consumerProperties.getNameServer());
        consumer.setMessageModel(RocketMQConsumerFactory.getMessageModel(consumerProperties.getMessageModel()));
        consumer.setUseTLS(consumerProperties.getUseTLS());
        consumer.setPullTimeDelayMillsWhenException(consumerProperties.getPullTimeDelayMillsWhenException());
        consumer.setConsumerTimeoutMillisWhenSuspend(consumerProperties.getPull().getConsumerTimeoutMillisWhenSuspend());
        consumer.setPullBatchSize(consumerProperties.getPullBatchSize());
        consumer.setConsumeFromWhere(consumerProperties.getConsumeFromWhere());
        consumer.setHeartbeatBrokerInterval(consumerProperties.getHeartbeatBrokerInterval());
        consumer.setPersistConsumerOffsetInterval(consumerProperties.getPersistConsumerOffsetInterval());
        consumer.setPollTimeoutMillis(consumerProperties.getPull().getPollTimeoutMillis());
        consumer.setPullThreadNums(extendedConsumerProperties.getConcurrency());
        consumer.setPullThresholdForAll(((RocketMQConsumerProperties)extendedConsumerProperties.getExtension()).getPull().getPullThresholdForAll());
        consumer.setUnitName(consumerProperties.getUnitName());
        return consumer;
    }

    private static MessageModel getMessageModel(String messageModel) {
        for (MessageModel model : MessageModel.values()) {
            if (!model.getModeCN().equalsIgnoreCase(messageModel)) continue;
            return model;
        }
        return MessageModel.CLUSTERING;
    }
}

