/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.extension;

import com.alibaba.cola.extension.BizScenario;
import com.alibaba.cola.extension.ExtensionCoordinate;
import com.alibaba.cola.extension.ExtensionException;
import com.alibaba.cola.extension.ExtensionPointI;
import com.alibaba.cola.extension.ExtensionRepository;
import com.alibaba.cola.extension.register.AbstractComponentExecutor;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExtensionExecutor
extends AbstractComponentExecutor {
    private static final String EXTENSION_NOT_FOUND = "extension_not_found";
    private Logger logger = LoggerFactory.getLogger(ExtensionExecutor.class);
    @Resource
    private ExtensionRepository extensionRepository;

    @Override
    protected <C> C locateComponent(Class<C> targetClz, BizScenario bizScenario) {
        C extension = this.locateExtension(targetClz, bizScenario);
        this.logger.debug("[Located Extension]: " + extension.getClass().getSimpleName());
        return extension;
    }

    protected <Ext> Ext locateExtension(Class<Ext> targetClz, BizScenario bizScenario) {
        this.checkNull(bizScenario);
        this.logger.debug("BizScenario in locateExtension is : " + bizScenario.getUniqueIdentity());
        Ext extension = this.firstTry(targetClz, bizScenario);
        if (extension != null) {
            return extension;
        }
        extension = this.secondTry(targetClz, bizScenario);
        if (extension != null) {
            return extension;
        }
        extension = this.defaultUseCaseTry(targetClz, bizScenario);
        if (extension != null) {
            return extension;
        }
        String errMessage = "Can not find extension with ExtensionPoint: " + targetClz + " BizScenario:" + bizScenario.getUniqueIdentity();
        throw new ExtensionException(EXTENSION_NOT_FOUND, errMessage);
    }

    private <Ext> Ext firstTry(Class<Ext> targetClz, BizScenario bizScenario) {
        this.logger.debug("First trying with " + bizScenario.getUniqueIdentity());
        return this.locate(targetClz.getName(), bizScenario.getUniqueIdentity());
    }

    private <Ext> Ext secondTry(Class<Ext> targetClz, BizScenario bizScenario) {
        this.logger.debug("Second trying with " + bizScenario.getIdentityWithDefaultScenario());
        return this.locate(targetClz.getName(), bizScenario.getIdentityWithDefaultScenario());
    }

    private <Ext> Ext defaultUseCaseTry(Class<Ext> targetClz, BizScenario bizScenario) {
        this.logger.debug("Third trying with " + bizScenario.getIdentityWithDefaultUseCase());
        return this.locate(targetClz.getName(), bizScenario.getIdentityWithDefaultUseCase());
    }

    private <Ext> Ext locate(String name, String uniqueIdentity) {
        ExtensionPointI ext = this.extensionRepository.getExtensionRepo().get(new ExtensionCoordinate(name, uniqueIdentity));
        return (Ext)ext;
    }

    private void checkNull(BizScenario bizScenario) {
        if (bizScenario == null) {
            throw new IllegalArgumentException("BizScenario can not be null for extension");
        }
    }
}

