/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.extension.register;

import com.alibaba.cola.extension.Extension;
import com.alibaba.cola.extension.ExtensionPointI;
import com.alibaba.cola.extension.Extensions;
import com.alibaba.cola.extension.register.ExtensionRegister;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ExtensionBootstrap
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ExtensionBootstrap.class);
    @Resource
    private ExtensionRegister extensionRegister;
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        Map extMap = this.applicationContext.getBeansOfType(ExtensionPointI.class);
        for (ExtensionPointI ext : extMap.values()) {
            if (ext.getClass().isAnnotationPresent(Extension.class)) {
                this.extensionRegister.doRegistration(ext);
                continue;
            }
            if (ext.getClass().isAnnotationPresent(Extensions.class)) {
                this.extensionRegister.doRegistrationExtensions(ext);
                continue;
            }
            log.error("There is no annotation for @Extension or @Extension on this extension class:{}", ext.getClass());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

