/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.extension.register;

import com.alibaba.cola.extension.BizScenario;
import com.alibaba.cola.extension.Extension;
import com.alibaba.cola.extension.ExtensionCoordinate;
import com.alibaba.cola.extension.ExtensionException;
import com.alibaba.cola.extension.ExtensionPointI;
import com.alibaba.cola.extension.ExtensionRepository;
import com.alibaba.cola.extension.Extensions;
import jakarta.annotation.Resource;
import java.lang.reflect.AnnotatedElement;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class ExtensionRegister {
    private static final String EXTENSION_INTERFACE_NAME_ILLEGAL = "extension_interface_name_illegal";
    private static final String EXTENSION_ILLEGAL = "extension_illegal";
    private static final String EXTENSION_DEFINE_DUPLICATE = "extension_define_duplicate";
    @Resource
    private ExtensionRepository extensionRepository;
    public static final String EXTENSION_EXTPT_NAMING = "ExtPt";

    public void doRegistration(ExtensionPointI extensionObject) {
        Class extensionClz = extensionObject.getClass();
        if (AopUtils.isAopProxy((Object)extensionObject)) {
            extensionClz = AopUtils.getTargetClass((Object)extensionObject);
        }
        Extension extensionAnn = (Extension)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)extensionClz, Extension.class);
        BizScenario bizScenario = BizScenario.valueOf((String)extensionAnn.bizId(), (String)extensionAnn.useCase(), (String)extensionAnn.scenario());
        ExtensionCoordinate extensionCoordinate = new ExtensionCoordinate(this.calculateExtensionPoint(extensionClz), bizScenario.getUniqueIdentity());
        ExtensionPointI preVal = this.extensionRepository.getExtensionRepo().put(extensionCoordinate, extensionObject);
        if (preVal != null) {
            String errMessage = "Duplicate registration is not allowed for :" + extensionCoordinate;
            throw new ExtensionException(EXTENSION_DEFINE_DUPLICATE, errMessage);
        }
    }

    public void doRegistrationExtensions(ExtensionPointI extensionObject) {
        Class extensionClz = extensionObject.getClass();
        if (AopUtils.isAopProxy((Object)extensionObject)) {
            extensionClz = ClassUtils.getUserClass((Object)extensionObject);
        }
        Extensions extensionsAnnotation = (Extensions)AnnotationUtils.findAnnotation((Class)extensionClz, Extensions.class);
        String[] bizIds = extensionsAnnotation.bizId();
        String[] useCases = extensionsAnnotation.useCase();
        String[] scenarios = extensionsAnnotation.scenario();
        for (String bizId : bizIds) {
            for (String useCase : useCases) {
                for (String scenario : scenarios) {
                    BizScenario bizScenario = BizScenario.valueOf((String)bizId, (String)useCase, (String)scenario);
                    ExtensionCoordinate extensionCoordinate = new ExtensionCoordinate(this.calculateExtensionPoint(extensionClz), bizScenario.getUniqueIdentity());
                    ExtensionPointI preVal = this.extensionRepository.getExtensionRepo().put(extensionCoordinate, extensionObject);
                    if (preVal == null) continue;
                    String errMessage = "Duplicate registration is not allowed for :" + extensionCoordinate;
                    throw new ExtensionException(EXTENSION_DEFINE_DUPLICATE, errMessage);
                }
            }
        }
    }

    private String calculateExtensionPoint(Class<?> targetClz) {
        Class[] interfaces = ClassUtils.getAllInterfacesForClass(targetClz);
        if (interfaces == null || interfaces.length == 0) {
            throw new ExtensionException(EXTENSION_ILLEGAL, "Please assign a extension point interface for " + targetClz);
        }
        for (Class intf : interfaces) {
            String extensionPoint = intf.getSimpleName();
            if (!extensionPoint.contains(EXTENSION_EXTPT_NAMING)) continue;
            return intf.getName();
        }
        String errMessage = "Your name of ExtensionPoint for " + targetClz + " is not valid, must be end of ExtPt";
        throw new ExtensionException(EXTENSION_INTERFACE_NAME_ILLEGAL, errMessage);
    }
}

