package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.transport.CommandCenter;
import com.alibaba.csp.sentinel.transport.command.SimpleHttpCommandCenter;

import com.taobao.csp.ahas.service.component.AgwComponentManager;

/**
 * Sentinel command center based on Ahas gateway.
 *
 * @author leyou 2018/12/10
 */
@SpiOrder(-10000)
public class AhasCommandCenter implements CommandCenter {

    DefaultSentinelSdkService service = DefaultSentinelSdkService.getInstance();

    private CommandCenter innerDelegate;

    public AhasCommandCenter() {
        // NOTE: DO NOT remove this!
        org.apache.log4j.helpers.LogLog.setQuietMode(true);
    }

    @Override
    public void beforeStart() throws Exception {
        if (AgwComponentManager.isInner()) {
            if (innerDelegate == null) {
                innerDelegate = new SimpleHttpCommandCenter(8718);
            }
            innerDelegate.beforeStart();
        }
    }

    @Override
    public void start() throws Exception {
        service.init();

        if (innerDelegate != null) {
            innerDelegate.start();
        }
    }

    @Override
    public void stop() throws Exception { }
}
