package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.sentinel.adapter.gateway.common.slot.GatewayFlowSlot;
import com.alibaba.csp.sentinel.slotchain.DefaultProcessorSlotChain;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotChain;
import com.alibaba.csp.sentinel.slotchain.SlotChainBuilder;
import com.alibaba.csp.sentinel.slots.block.authority.AuthoritySlot;
import com.alibaba.csp.sentinel.slots.block.degrade.DefaultCircuitBreakerSlot;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeSlot;
import com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeSlot;
import com.alibaba.csp.sentinel.slots.block.flow.FlowSlot;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowSlot;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.alibaba.csp.sentinel.slots.logger.LogSlot;
import com.alibaba.csp.sentinel.slots.nodeselector.NodeSelectorSlot;
import com.alibaba.csp.sentinel.slots.statistic.StatisticSlot;
import com.alibaba.csp.sentinel.slots.stresstest.StressingTestPriorityModeSlot;
import com.alibaba.csp.sentinel.slots.system.SystemSlot;
import com.alibaba.csp.sentinel.spi.SpiOrder;

import com.alibaba.csp.sentinel.web.adapter.common.slot.WebFlowSlot;
import com.taobao.csp.ahas.service.component.AgwComponentManager;

/**
 * @author Eric Zhao
 * @since 1.9.2
 */
@SpiOrder(SpiOrder.HIGHEST_PRECEDENCE)
public class AhasSentinelSlotChainBuilder implements SlotChainBuilder {

    private final boolean innerEnv = AgwComponentManager.isInner();

    @Override
    public ProcessorSlotChain build() {
        ProcessorSlotChain chain = new DefaultProcessorSlotChain();

        if (innerEnv) {
            chain.addLast(new StressingTestPriorityModeSlot());
        }

        chain.addLast(new NodeSelectorSlot());
        chain.addLast(new ClusterBuilderSlot());
        chain.addLast(new LogSlot());
        chain.addLast(new StatisticSlot());
        chain.addLast(new ManualDegradeSlot());
        chain.addLast(new AuthoritySlot());
        chain.addLast(new SystemSlot());
        chain.addLast(new GatewayFlowSlot());
        chain.addLast(new WebFlowSlot());
        chain.addLast(new ParamFlowSlot());
        chain.addLast(new FlowSlot());
        chain.addLast(new DefaultCircuitBreakerSlot());
        chain.addLast(new DegradeSlot());
        return chain;
    }
}