package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;

/**
 * @author Eric Zhao
 * @since 1.9.2
 */
@SpiOrder(-10000)
public class NoopHeartbeatSender implements HeartbeatSender {

    @Override
    public boolean sendHeartbeat() throws Exception {
        return false;
    }

    @Override
    public long intervalMs() {
        // Skip raw Sentinel heartbeat by default
        return -1;
    }
}
