package com.alibaba.csp.ahas.sentinel.acm;

import java.util.List;

import com.alibaba.csp.ahas.sentinel.AhasSentinelConstants;
import com.alibaba.csp.ahas.sentinel.init.AhasSentinelInitFunc;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.SpiLoader;

import com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.middleware.logger.support.LogLog;

/**
 * @author yunyin
 * @author Eric Zhao
 */
public abstract class AbstractSentinelSdkInitService implements SentinelSdkInitService {
    private static final String SENTINEL_ENV_CLASS = "com.alibaba.csp.sentinel.Env";

    protected final ClientInfoService clientInfoService;

    public AbstractSentinelSdkInitService(ClientInfoService clientInfoService) {
        this.clientInfoService = clientInfoService;
    }

    @Override
    public void init(String sdkVersion) throws Exception {
        // do not print stack trace when logger not found for ACM.
        LogLog.setQuietMode(true);
        initBySpi();
        init0(sdkVersion);
        initSentinel();
    }

    private void initBySpi() {
        try {
            List<AhasSentinelInitFunc> initFuncList = SpiLoader.loadInstanceListSorted(AhasSentinelInitFunc.class);
            for (AhasSentinelInitFunc initFunc : initFuncList) {
                initFunc.init(clientInfoService);
            }
        } catch (Throwable t) {
            RecordLog.warn("Failed to initialize by AhasSentinelInitFunc SPI", t);
        }
    }

    /**
     * Abstract method, implemented by sub classes.
     *
     * @param sdkVersion
     */
    protected abstract void init0(String sdkVersion) throws Exception;

    /**
     * Invoke Sentinel bootstrap class
     *
     * @throws ClassNotFoundException
     */
    private void initSentinel() throws Exception {
        try {
            this.getClass().getClassLoader().loadClass(SENTINEL_ENV_CLASS);
        } catch (ClassNotFoundException e) {
            RecordLog.warn("[DefaultSentinelSdkService][ERROR] " + SENTINEL_ENV_CLASS + " not found!", e);
        }
    }

    protected boolean isGatewayAppType() {
        return AhasSentinelConstants.GATEWAY_APP_TYPES.contains(
            com.taobao.csp.ahas.service.util.AppNameUtil.getAppType());
    }
}
