package com.alibaba.csp.ahas.sentinel.acm;

import com.alibaba.csp.ahas.sentinel.datasource.parser.ApplicationClusterInfoParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.ParamFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.fallback.BlockFallbackConfigListParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayApiDefinitionParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdapterSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdaptiveFlowSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelGeneralSettingParser;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingEntity;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingManager;
import com.alibaba.csp.sentinel.datasource.acm.DiamondDataSource;
import com.alibaba.csp.sentinel.datasource.acm.SentinelAcmConstants;
import com.alibaba.csp.sentinel.datasource.acm.parser.DegradeRuleConfigParser;
import com.alibaba.csp.sentinel.datasource.acm.parser.FlowRuleConfigParser;
import com.alibaba.csp.sentinel.datasource.acm.parser.ManualDegradeRuleListParser;
import com.alibaba.csp.sentinel.datasource.acm.parser.RetryRuleListParser;
import com.alibaba.csp.sentinel.datasource.acm.parser.SystemRuleConfigParser;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.machine.MachineGroupEntity;
import com.alibaba.csp.sentinel.machine.MachineGroupManager;
import com.alibaba.csp.sentinel.retry.RetryRule;
import com.alibaba.csp.sentinel.retry.RetryRuleManager;
import com.alibaba.csp.sentinel.setting.adapter.AdapterSettingManager;
import com.alibaba.csp.sentinel.setting.adapter.SentinelAdapterSettingEntity;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfigManager;
import com.alibaba.csp.sentinel.setting.general.GeneralSettingManager;
import com.alibaba.csp.sentinel.setting.general.SentinelGeneralSettingEntity;
import com.alibaba.csp.sentinel.slots.block.degrade.DefaultCircuitBreakerRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;

import com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.taobao.diamond.exception.DiamondException;

import java.util.List;
import java.util.Set;

import static com.alibaba.csp.sentinel.datasource.acm.SentinelAcmConstants.SENTINEL_GROUP_ID;

/**
 * @Author: yunyin
 * @Date: 2020/8/24
 */
public class ApsaraSdkInitService extends AbstractSentinelSdkInitService {

    public ApsaraSdkInitService(ClientInfoService clientInfoService) {
        super(clientInfoService);
    }

    /**
     * Apsara sdk init method
     *
     * @param sdkVersion
     */
    @Override
    public void init0(String sdkVersion) throws Exception {
        initAcmDataSource();
    }

    /**
     * Init acm datasource
     *
     * @throws DiamondException
     */
    private void initAcmDataSource() throws DiamondException {
        String namespace = clientInfoService.getNamespace();
        String userId = clientInfoService.getUserId();
        String consoleTenantId = clientInfoService.getTid();
        String appName = clientInfoService.getAppName();

        initSettingDs(consoleTenantId, userId, namespace, appName);
        initBlockFallbackDs(consoleTenantId, userId, namespace, appName);
        initApplicationClusterInfoDs(consoleTenantId, userId, namespace, appName);
        initClientRuleDs(consoleTenantId, userId, namespace, appName);

        // Register data source related to gateway adapter.
        if (isGatewayAppType()) {
            initApiGatewayDs(consoleTenantId, userId, namespace, appName);
        }
    }

    private void initClientRuleDs(String consoleTenantId, final String userId, final String namespace, String appName)
        throws DiamondException {

        String flowDataId = SentinelAcmConstants.formFlowRuleDataId(userId, namespace, appName);
        FlowRuleManager.register2Property(new DiamondDataSource<List<FlowRule>>(consoleTenantId,
            flowDataId, SENTINEL_GROUP_ID, new FlowRuleConfigParser()).getProperty());

        String degradeDataId = SentinelAcmConstants.formDegradeRuleDataId(userId, namespace, appName);
        DegradeRuleManager.register2Property(new DiamondDataSource<List<DegradeRule>>(consoleTenantId,
            degradeDataId, SENTINEL_GROUP_ID, new DegradeRuleConfigParser()).getProperty());

        // Default circuit breaker rule: since 1.9.6
        String defaultCbRuleDataId = SentinelAcmConstants.formDefaultCircuitBreakerRuleDataId(
            userId, namespace, appName);
        DefaultCircuitBreakerRuleManager.register2Property(new DiamondDataSource<List<DegradeRule>>(
            consoleTenantId, defaultCbRuleDataId, SENTINEL_GROUP_ID, new DegradeRuleConfigParser()).getProperty());

        String systemDataId = SentinelAcmConstants.formSystemRuleDataId(userId, namespace, appName);
        SystemRuleManager.register2Property(new DiamondDataSource<List<SystemRule>>(consoleTenantId,
            systemDataId, SENTINEL_GROUP_ID, new SystemRuleConfigParser()).getProperty());

        // Since AHAS Sentinel client 1.5.0.
        final String paramFlowDataId = SentinelAcmConstants.formParamFlowRuleDataId(userId, namespace, appName);
        ParamFlowRuleManager.register2Property(new DiamondDataSource<List<ParamFlowRule>>(consoleTenantId,
            paramFlowDataId, SENTINEL_GROUP_ID, new ParamFlowRuleParser()).getProperty());

        // Retry rule: since 1.8.0
        String retryRuleDataId = SentinelAcmConstants.formRetryRuleDataId(userId, namespace, appName);
        RetryRuleManager.getInstance().register2Property(
            new DiamondDataSource<List<RetryRule>>(consoleTenantId, retryRuleDataId, SENTINEL_GROUP_ID,
                new RetryRuleListParser()).getProperty()
        );

        // Manual degrade rule: since 1.8.4
        String mdrDataId = SentinelAcmConstants.formManualDegradeRuleDataId(userId, namespace, appName);
        ManualDegradeRuleManager.getInstance().register2Property(
            new DiamondDataSource<List<ManualDegradeRule>>(consoleTenantId, mdrDataId,
                SENTINEL_GROUP_ID, new ManualDegradeRuleListParser()).getProperty()
        );

        String log = String.format("Diamond, flowDataId: %s, degradeDataId: %s, groupId: %s, namespace: %s",
            flowDataId, degradeDataId, SENTINEL_GROUP_ID, namespace);
        RecordLog.info(log);
    }

    private void initApiGatewayDs(String consoleTenantId, String userId, String acmNamespace, String appName)
        throws DiamondException {
        RecordLog.info("[SentinelDiamondDsService] Initializing data source for API gateway integration");

        String gatewayFlowRuleDataId = SentinelAcmConstants.formGatewayFlowRuleDataId(userId, acmNamespace, appName);

        // Init gateway flow rule data source.
        DiamondDataSource<Set<GatewayFlowRule>> gatewayFlowRuleDs = new DiamondDataSource<Set<GatewayFlowRule>>(
            consoleTenantId, gatewayFlowRuleDataId, SENTINEL_GROUP_ID, new GatewayFlowRuleParser());
        GatewayRuleManager.register2Property(gatewayFlowRuleDs.getProperty());

        String gatewayApiDefDataId = SentinelAcmConstants.formGatewayApiDefinitionDataId(userId, acmNamespace, appName);

        // Init gateway API definition data source.
        DiamondDataSource<Set<ApiDefinition>> gatewayApiDefinitionDs = new DiamondDataSource<Set<ApiDefinition>>(
            consoleTenantId, gatewayApiDefDataId, SENTINEL_GROUP_ID, new GatewayApiDefinitionParser());
        GatewayApiDefinitionManager.register2Property(gatewayApiDefinitionDs.getProperty());
    }

    private void initSettingDs(String consoleTenantId, String userId, String acmNamespace, String appName)
        throws DiamondException {
        // We could register the observer for adapter settings here.
        // For example, we could leverage the consumer to update the configuration of Web URL prefix cleaner.

        String gsDataId = SentinelAcmConstants.formGeneralSettingDataId(userId, acmNamespace, appName);
        DiamondDataSource<SentinelGeneralSettingEntity> generalSettingDs
            = new DiamondDataSource<SentinelGeneralSettingEntity>(
            consoleTenantId, gsDataId, SENTINEL_GROUP_ID, new SentinelGeneralSettingParser());
        GeneralSettingManager.register2Property(generalSettingDs.getProperty());

        String asDataId = SentinelAcmConstants.formAdapterSettingDataId(userId, acmNamespace, appName);
        DiamondDataSource<SentinelAdapterSettingEntity> adapterSettingDs
            = new DiamondDataSource<SentinelAdapterSettingEntity>(
            consoleTenantId, asDataId, SENTINEL_GROUP_ID, new SentinelAdapterSettingParser());
        AdapterSettingManager.register2Property(adapterSettingDs.getProperty());

        String afSettingDataId = SentinelAcmConstants.formAdaptiveFlowSettingDataId(userId,
            acmNamespace, appName);
        DiamondDataSource<AdaptiveFlowSettingEntity> adaptiveFlowSettingDs
            = new DiamondDataSource<AdaptiveFlowSettingEntity>(consoleTenantId, afSettingDataId,
            SENTINEL_GROUP_ID, new SentinelAdaptiveFlowSettingParser());
        AdaptiveFlowSettingManager.register2Property(adaptiveFlowSettingDs.getProperty());
    }

    private void initBlockFallbackDs(String tenantId, String userId, String namespace, String appName)
        throws DiamondException {
        String bfcDataId = SentinelAcmConstants.formBlockFallbackConfigDataId(userId, namespace, appName);
        BlockFallbackConfigManager.getInstance().register2Property(
            new DiamondDataSource<List<BlockFallbackConfig<Object>>>(tenantId, bfcDataId,
                SENTINEL_GROUP_ID, new BlockFallbackConfigListParser()).getProperty());
    }

    private void initApplicationClusterInfoDs(String tenantId, String userId, String namespace, String appName)
        throws DiamondException {
        // 应用集群的基本状态信息（如在线机器数）.
        String machineGroupDataId = SentinelAcmConstants.formMachineGroupDataId(userId, namespace, appName);
        MachineGroupManager.register2Property(new DiamondDataSource<MachineGroupEntity>(tenantId, machineGroupDataId,
            SENTINEL_GROUP_ID, new ApplicationClusterInfoParser()).getProperty());
    }
}
