package com.alibaba.csp.ahas.sentinel.acm;

import com.alibaba.csp.sentinel.util.StringUtil;

import com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.taobao.csp.ahas.service.api.constant.AppConstants;
import com.taobao.csp.ahas.service.component.AgwComponentType;

/**
 * @author yunyin
 * @author Eric Zhao
 * @date 2020/8/24
 */
public class SentinelSdkInitServiceManager {

    public static int getMode() {
        int defaultValue = AgwComponentType.PUBLIC_CLOUD.getType();
        try {
            String agwTypeStr = System.getProperty(AppConstants.AHAS_AGW_COMPONENT_TYPE);
            if (StringUtil.isEmpty(agwTypeStr)) {
                return defaultValue;
            }
            return Integer.parseInt(agwTypeStr);
        } catch (Exception ex) {
            return defaultValue;
        }
    }

    public static SentinelSdkInitService getInitService(ClientInfoService clientInfoService) {
        int mode = getMode();
        if (AgwComponentType.PRIVATE_CLOUD.getType() == mode) {
            return new ApsaraSdkInitService(clientInfoService);
        } else if (AgwComponentType.INNER_CLOUD.getType() == mode) {
            return new InnerCloudAhasInitService(clientInfoService);
        }
        return new DefaultSdkInitService(clientInfoService);
    }
}
