package com.alibaba.csp.ahas.sentinel.datasource.parser;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.acm.RulesAcmFormat;
import com.alibaba.csp.sentinel.machine.MachineGroupEntity;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;

public class ApplicationClusterInfoParser implements Converter<String, MachineGroupEntity> {

    @Override
    public MachineGroupEntity convert(String source) {
        if (StringUtil.isBlank(source)) {
            return null;
        }
        String data = new RulesAcmFormat(source).getData();
        if (StringUtil.isBlank(data)) {
            return null;
        }
        return JSON.parseObject(data, MachineGroupEntity.class);
    }
}
