package com.alibaba.csp.ahas.sentinel.datasource.parser;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.web.adapter.common.rule.WebFlowRule;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

import java.util.Set;

/**
 * @author guanyu
 * @since 1.10.0
 */
public class WebFlowRuleParser implements Converter<String, Set<WebFlowRule>> {

    @Override
    public Set<WebFlowRule> convert(String source) {
        if (StringUtil.isBlank(source)) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        return JSON.parseObject(data, new TypeReference<Set<WebFlowRule>>() {});
    }
}
