package com.alibaba.csp.ahas.sentinel.datasource.parser.cluster;

import java.util.List;

import com.alibaba.csp.ahas.sentinel.cluster.entity.ClusterGroupEntity;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

/**
 * @author Eric Zhao
 */
public class ClusterAssignStateParser implements Converter<String, Integer> {

    @Override
    public Integer convert(String source) {
        if (source == null) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        List<ClusterGroupEntity> groupList = JSON.parseObject(data, new TypeReference<List<ClusterGroupEntity>>() {});
        if (groupList == null || groupList.isEmpty()) {
            return ClusterStateManager.CLUSTER_NOT_STARTED;
        }
        return extractMode(groupList);
    }

    private int extractMode(List<ClusterGroupEntity> groupList) {
        // If any server group machine matches current, then it's token server.
        for (ClusterGroupEntity group : groupList) {
            if (group.getClientSet() != null) {
                if (group.getClientSet().contains("all")) {
                    return ClusterStateManager.CLUSTER_CLIENT;
                }
                for (String client : group.getClientSet()) {
                    if (client != null && client.equals(MachineUtils.getCurrentProcessConfigurationId())) {
                        return ClusterStateManager.CLUSTER_CLIENT;
                    }
                }
            }
        }
        return ClusterStateManager.CLUSTER_NOT_STARTED;
    }
}
