package com.alibaba.csp.ahas.sentinel.datasource.parser.cluster;

import java.util.List;
import java.util.Set;

import com.alibaba.csp.ahas.sentinel.cluster.entity.ClusterGroupEntity;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;

/**
 * @author Eric Zhao
 */
public class ClusterClientAssignConfigParser implements Converter<String, ClusterClientAssignConfig> {

    @Override
    public ClusterClientAssignConfig convert(String source) {
        if (source == null) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        List<ClusterGroupEntity> groupList = JSON.parseObject(data, new TypeReference<List<ClusterGroupEntity>>() {});
        if (groupList == null || groupList.isEmpty()) {
            return null;
        }
        return extractClientAssignment(groupList);
    }

    private ClusterClientAssignConfig extractClientAssignment(List<ClusterGroupEntity> groupList) {
        // Build client assign config from the client set of target server group.
        for (ClusterGroupEntity group : groupList) {
            Set<String> clientSet = group.getClientSet();
            String self = MachineUtils.getCurrentProcessConfigurationId();
            if (clientSet.contains("all") || clientSet.contains(self)) {
                String ip = group.getIp();
                Integer port = group.getPort();
                return new ClusterClientAssignConfig(ip, port);
            }
        }
        // Not assigned.
        return null;
    }
}
