package com.alibaba.csp.ahas.sentinel.datasource.parser.fallback;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig.RpcBlockFallbackBehavior;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig.WebBlockFallbackBehavior;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConstants;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

/**
 * @author Eric Zhao
 */
public class BlockFallbackConfigListParser implements Converter<String, List<BlockFallbackConfig<Object>>> {

    @Override
    public List<BlockFallbackConfig<Object>> convert(String source) {
        if (StringUtil.isBlank(source)) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        if (StringUtil.isBlank(data)) {
            return null;
        }
        JSONArray arr = JSON.parseArray(data);
        List<BlockFallbackConfig<Object>> list = new ArrayList<BlockFallbackConfig<Object>>();
        if (arr.isEmpty()) {
            return list;
        }
        for (Object obj : arr) {
            if (obj instanceof JSONObject) {
                JSONObject item = (JSONObject) obj;
                Integer targetResourceType = item.getInteger("targetResourceType");
                if (targetResourceType == null || !BlockFallbackConstants.isResourceTypeSupported(targetResourceType)) {
                    continue;
                }
                if (targetResourceType == BlockFallbackConstants.TARGET_RES_TYPE_WEB) {
                    list.add(item.<BlockFallbackConfig<Object>>toJavaObject(
                        new TypeReference<BlockFallbackConfig<WebBlockFallbackBehavior>>() {}));
                } else if (targetResourceType == BlockFallbackConstants.TARGET_RES_TYPE_RPC) {
                    list.add(item.<BlockFallbackConfig<Object>>toJavaObject(
                        new TypeReference<BlockFallbackConfig<RpcBlockFallbackBehavior>>() {}));
                }
            }
        }
        return list;
    }
}
