/*
 * Copyright 1999-2020 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.csp.ahas.sentinel.datasource.parser.setting;

import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingEntity;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.acm.RulesAcmFormat;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;

/**
 * @author Eric Zhao
 */
public class SentinelAdaptiveFlowSettingParser implements Converter<String, AdaptiveFlowSettingEntity> {

    @Override
    public AdaptiveFlowSettingEntity convert(String source) {
        if (StringUtil.isBlank(source)) {
            return null;
        }
        String data = new RulesAcmFormat(source).getData();
        if (StringUtil.isBlank(data)) {
            return null;
        }
        return JSON.parseObject(data, AdaptiveFlowSettingEntity.class);
    }
}
