/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.annotation.cdi.interceptor;

import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.annotation.cdi.interceptor.MethodWrapper;
import com.alibaba.csp.sentinel.annotation.cdi.interceptor.ResourceMetadataRegistry;
import com.alibaba.csp.sentinel.annotation.cdi.interceptor.SentinelResourceBinding;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.MethodUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javax.interceptor.InvocationContext;

public abstract class AbstractSentinelInterceptorSupport {
    protected void traceException(Throwable ex) {
        Tracer.trace((Throwable)ex);
    }

    protected void traceException(Throwable ex, SentinelResourceBinding annotation) {
        Class<? extends Throwable>[] exceptionsToIgnore = annotation.exceptionsToIgnore();
        if (exceptionsToIgnore.length > 0 && this.exceptionBelongsTo(ex, exceptionsToIgnore)) {
            return;
        }
        if (this.exceptionBelongsTo(ex, annotation.exceptionsToTrace())) {
            this.traceException(ex);
        }
    }

    protected boolean exceptionBelongsTo(Throwable ex, Class<? extends Throwable>[] exceptions) {
        if (exceptions == null) {
            return false;
        }
        for (Class<? extends Throwable> exceptionClass : exceptions) {
            if (!exceptionClass.isAssignableFrom(ex.getClass())) continue;
            return true;
        }
        return false;
    }

    protected String getResourceName(String resourceName, Method method) {
        if (StringUtil.isNotBlank((String)resourceName)) {
            return resourceName;
        }
        return MethodUtil.resolveMethodName((Method)method);
    }

    protected Object handleFallback(InvocationContext ctx, SentinelResourceBinding annotation, Throwable ex) throws Throwable {
        return this.handleFallback(ctx, annotation.fallback(), annotation.defaultFallback(), annotation.fallbackClass(), ex);
    }

    protected Object handleFallback(InvocationContext ctx, String fallback, String defaultFallback, Class<?>[] fallbackClass, Throwable ex) throws Throwable {
        Object[] originArgs = ctx.getParameters();
        Method fallbackMethod = this.extractFallbackMethod(ctx, fallback, fallbackClass);
        if (fallbackMethod != null) {
            Object[] args;
            int paramCount = fallbackMethod.getParameterTypes().length;
            if (paramCount == originArgs.length) {
                args = originArgs;
            } else {
                args = Arrays.copyOf(originArgs, originArgs.length + 1);
                args[args.length - 1] = ex;
            }
            try {
                if (this.isStatic(fallbackMethod)) {
                    return fallbackMethod.invoke(null, args);
                }
                return fallbackMethod.invoke(ctx.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.handleDefaultFallback(ctx, defaultFallback, fallbackClass, ex);
    }

    protected Object handleDefaultFallback(InvocationContext ctx, String defaultFallback, Class<?>[] fallbackClass, Throwable ex) throws Throwable {
        Method fallbackMethod = this.extractDefaultFallbackMethod(ctx, defaultFallback, fallbackClass);
        if (fallbackMethod != null) {
            Object[] objectArray;
            if (fallbackMethod.getParameterTypes().length == 0) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = ex;
            }
            Object[] args = objectArray;
            try {
                if (this.isStatic(fallbackMethod)) {
                    return fallbackMethod.invoke(null, args);
                }
                return fallbackMethod.invoke(ctx.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        throw ex;
    }

    protected Object handleBlockException(InvocationContext ctx, SentinelResourceBinding annotation, BlockException ex) throws Throwable {
        Method blockHandlerMethod = this.extractBlockHandlerMethod(ctx, annotation.blockHandler(), annotation.blockHandlerClass());
        if (blockHandlerMethod != null) {
            Object[] originArgs = ctx.getParameters();
            Object[] args = Arrays.copyOf(originArgs, originArgs.length + 1);
            args[args.length - 1] = ex;
            try {
                if (this.isStatic(blockHandlerMethod)) {
                    return blockHandlerMethod.invoke(null, args);
                }
                return blockHandlerMethod.invoke(ctx.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.handleFallback(ctx, annotation, ex);
    }

    private Method extractFallbackMethod(InvocationContext ctx, String fallbackName, Class<?>[] locationClass) {
        Method originMethod;
        if (StringUtil.isBlank((String)fallbackName)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : ctx.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupFallback(clazz, fallbackName, (originMethod = this.resolveMethod(ctx)).getParameterTypes());
        if (m == null) {
            Method method = this.resolveFallbackInternal(originMethod, fallbackName, clazz, mustStatic);
            ResourceMetadataRegistry.updateFallbackFor(clazz, fallbackName, originMethod.getParameterTypes(), method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method extractDefaultFallbackMethod(InvocationContext ctx, String defaultFallback, Class<?>[] locationClass) {
        boolean mustStatic;
        Class<?> clazz;
        MethodWrapper m;
        if (StringUtil.isBlank((String)defaultFallback)) {
            SentinelResource annotationClass = ctx.getTarget().getClass().getAnnotation(SentinelResource.class);
            if (annotationClass != null && StringUtil.isNotBlank((String)annotationClass.defaultFallback())) {
                defaultFallback = annotationClass.defaultFallback();
                if (locationClass == null || locationClass.length < 1) {
                    locationClass = annotationClass.fallbackClass();
                }
            } else {
                return null;
            }
        }
        if ((m = ResourceMetadataRegistry.lookupDefaultFallback(clazz = (mustStatic = locationClass != null && locationClass.length >= 1) ? locationClass[0] : ctx.getTarget().getClass(), defaultFallback)) == null) {
            Class<?> originReturnType = this.resolveMethod(ctx).getReturnType();
            Class[] defaultParamTypes = new Class[]{};
            Class[] paramTypeWithException = new Class[]{Throwable.class};
            Method method = this.findMethod(mustStatic, clazz, defaultFallback, originReturnType, defaultParamTypes);
            if (method == null) {
                method = this.findMethod(mustStatic, clazz, defaultFallback, originReturnType, paramTypeWithException);
            }
            ResourceMetadataRegistry.updateDefaultFallbackFor(clazz, defaultFallback, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveFallbackInternal(Method originMethod, String name, Class<?> clazz, boolean mustStatic) {
        Class<?>[] defaultParamTypes = originMethod.getParameterTypes();
        Class<?>[] paramTypesWithException = Arrays.copyOf(defaultParamTypes, defaultParamTypes.length + 1);
        paramTypesWithException[paramTypesWithException.length - 1] = Throwable.class;
        Method method = this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), defaultParamTypes);
        if (method == null) {
            method = this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), paramTypesWithException);
        }
        return method;
    }

    private Method extractBlockHandlerMethod(InvocationContext ctx, String name, Class<?>[] locationClass) {
        Method originMethod;
        if (StringUtil.isBlank((String)name)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : ctx.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupBlockHandler(clazz, name, (originMethod = this.resolveMethod(ctx)).getParameterTypes());
        if (m == null) {
            Method method = this.resolveBlockHandlerInternal(originMethod, name, clazz, mustStatic);
            ResourceMetadataRegistry.updateBlockHandlerFor(clazz, name, originMethod.getParameterTypes(), method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveBlockHandlerInternal(Method originMethod, String name, Class<?> clazz, boolean mustStatic) {
        Class<?>[] originList = originMethod.getParameterTypes();
        Class<?>[] parameterTypes = Arrays.copyOf(originList, originList.length + 1);
        parameterTypes[parameterTypes.length - 1] = BlockException.class;
        return this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), parameterTypes);
    }

    private boolean checkStatic(boolean mustStatic, Method method) {
        return !mustStatic || this.isStatic(method);
    }

    private Method findMethod(boolean mustStatic, Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !this.checkStatic(mustStatic, method) || !returnType.isAssignableFrom(method.getReturnType()) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
            RecordLog.info((String)"Resolved method [{}] in class [{}]", (Object[])new Object[]{name, clazz.getCanonicalName()});
            return method;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return this.findMethod(mustStatic, superClass, name, returnType, parameterTypes);
        }
        String methodType = mustStatic ? " static" : "";
        RecordLog.warn((String)"Cannot find{} method [{}] in class [{}] with parameters {}", (Object[])new Object[]{methodType, name, clazz.getCanonicalName(), Arrays.toString(parameterTypes)});
        return null;
    }

    private boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    protected Method resolveMethod(InvocationContext ctx) {
        Class<?> targetClass = ctx.getTarget().getClass();
        Method method = this.getDeclaredMethodFor(targetClass, ctx.getMethod().getName(), ctx.getMethod().getParameterTypes());
        if (method == null) {
            throw new IllegalStateException("Cannot resolve target method: " + ctx.getMethod().getName());
        }
        return method;
    }

    private Method getDeclaredMethodFor(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getDeclaredMethodFor(superClass, name, parameterTypes);
            }
            return null;
        }
    }
}

