/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.annotation.cdi.interceptor;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.annotation.cdi.interceptor.AbstractSentinelInterceptorSupport;
import com.alibaba.csp.sentinel.annotation.cdi.interceptor.SentinelResourceBinding;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@SentinelResourceBinding
@Priority(value=0)
public class SentinelResourceInterceptor
extends AbstractSentinelInterceptorSupport {
    @AroundInvoke
    Object aroundInvoke(InvocationContext ctx) throws Throwable {
        SentinelResourceBinding annotation = ctx.getMethod().getAnnotation(SentinelResourceBinding.class);
        if (annotation == null) {
            throw new IllegalStateException("Wrong state for SentinelResource annotation");
        }
        String resourceName = this.getResourceName(annotation.value(), ctx.getMethod());
        EntryType entryType = annotation.entryType();
        int resourceType = annotation.resourceType();
        Entry entry = null;
        try {
            Object result;
            entry = SphU.entry((String)resourceName, (int)resourceType, (EntryType)entryType, (Object[])ctx.getParameters());
            Object object = result = ctx.proceed();
            return object;
        }
        catch (BlockException ex) {
            Object object = this.handleBlockException(ctx, annotation, ex);
            return object;
        }
        catch (Throwable ex) {
            Class<? extends Throwable>[] exceptionsToIgnore = annotation.exceptionsToIgnore();
            if (exceptionsToIgnore.length > 0 && this.exceptionBelongsTo(ex, exceptionsToIgnore)) {
                throw ex;
            }
            if (this.exceptionBelongsTo(ex, annotation.exceptionsToTrace())) {
                this.traceException(ex);
                Object object = this.handleFallback(ctx, annotation, ex);
                return object;
            }
            throw ex;
        }
        finally {
            if (entry != null) {
                entry.exit(1, ctx.getParameters());
            }
        }
    }
}

