/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.data;

import com.alibaba.csp.sentinel.cluster.flow.statistic.data.ClusterFlowEvent;
import java.util.concurrent.atomic.LongAdder;

public class ClusterMetricBucket {
    private final LongAdder[] counters;

    public ClusterMetricBucket() {
        ClusterFlowEvent[] events = ClusterFlowEvent.values();
        this.counters = new LongAdder[events.length];
        for (ClusterFlowEvent event : events) {
            this.counters[event.ordinal()] = new LongAdder();
        }
    }

    public void reset() {
        for (ClusterFlowEvent event : ClusterFlowEvent.values()) {
            this.counters[event.ordinal()].reset();
        }
    }

    public long get(ClusterFlowEvent event) {
        return this.counters[event.ordinal()].sum();
    }

    public ClusterMetricBucket add(ClusterFlowEvent event, long count) {
        this.counters[event.ordinal()].add(count);
        return this;
    }
}

