/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server;

import com.alibaba.csp.sentinel.cluster.server.ClusterTokenServer;
import com.alibaba.csp.sentinel.cluster.server.codec.netty.NettyRequestDecoder;
import com.alibaba.csp.sentinel.cluster.server.codec.netty.NettyResponseEncoder;
import com.alibaba.csp.sentinel.cluster.server.connection.Connection;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionPool;
import com.alibaba.csp.sentinel.cluster.server.handler.TokenServerHandler;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyTransportServer
implements ClusterTokenServer {
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(Runtime.getRuntime().availableProcessors() * 2)));
    private static final int MAX_RETRY_TIMES = 3;
    private static final int RETRY_SLEEP_MS = 2000;
    private final int port;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;
    private final ConnectionPool connectionPool = new ConnectionPool();
    private final AtomicInteger currentState = new AtomicInteger(0);
    private final AtomicInteger failedTimes = new AtomicInteger(0);

    public NettyTransportServer(int port) {
        this.port = port;
    }

    public void start() {
        if (!this.currentState.compareAndSet(0, 1)) {
            return;
        }
        ServerBootstrap b = new ServerBootstrap();
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(DEFAULT_EVENT_LOOP_THREADS);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(1024, 0, 2, 0, 2)});
                p.addLast(new ChannelHandler[]{new NettyRequestDecoder()});
                p.addLast(new ChannelHandler[]{new LengthFieldPrepender(2)});
                p.addLast(new ChannelHandler[]{new NettyResponseEncoder()});
                p.addLast(new ChannelHandler[]{new TokenServerHandler(NettyTransportServer.this.connectionPool)});
            }
        }).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_SNDBUF, (Object)32768).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000).childOption(ChannelOption.SO_TIMEOUT, (Object)10).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_RCVBUF, (Object)32768);
        b.bind(this.port).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) {
                if (future.cause() != null) {
                    RecordLog.info((String)("[NettyTransportServer] Token server start failed (port=" + NettyTransportServer.this.port + "), failedTimes: " + NettyTransportServer.this.failedTimes.get()), (Throwable)future.cause());
                    NettyTransportServer.this.currentState.compareAndSet(1, 0);
                    int failCount = NettyTransportServer.this.failedTimes.incrementAndGet();
                    if (failCount > 3) {
                        return;
                    }
                    try {
                        Thread.sleep(failCount * 2000);
                        NettyTransportServer.this.start();
                    }
                    catch (Throwable e) {
                        RecordLog.info((String)"[NettyTransportServer] Failed to start token server when retrying", (Throwable)e);
                    }
                } else {
                    RecordLog.info((String)"[NettyTransportServer] Token server started success at port {}", (Object[])new Object[]{NettyTransportServer.this.port});
                    NettyTransportServer.this.currentState.compareAndSet(1, 2);
                }
            }
        });
    }

    public void stop() {
        while (this.currentState.get() == 1) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.currentState.compareAndSet(2, 0)) {
            try {
                this.bossGroup.shutdownGracefully();
                this.workerGroup.shutdownGracefully();
                this.connectionPool.shutdownAll();
                this.failedTimes.set(0);
                RecordLog.info((String)"[NettyTransportServer] Sentinel token server stopped", (Object[])new Object[0]);
            }
            catch (Exception ex) {
                RecordLog.warn((String)("[NettyTransportServer] Failed to stop token server (port=" + this.port + ")"), (Throwable)ex);
            }
        }
    }

    public void refreshRunningServer() {
        this.connectionPool.refreshIdleTask();
    }

    public void closeConnection(String clientIp, int clientPort) throws Exception {
        Connection connection = this.connectionPool.getConnection(clientIp, clientPort);
        connection.close();
    }

    public void closeAll() throws Exception {
        List<Connection> connections = this.connectionPool.listAllConnection();
        for (Connection connection : connections) {
            connection.close();
        }
    }

    public List<String> listAllClient() {
        ArrayList<String> clients = new ArrayList<String>();
        List<Connection> connections = this.connectionPool.listAllConnection();
        for (Connection conn : connections) {
            clients.add(conn.getConnectionKey());
        }
        return clients;
    }

    public int getCurrentState() {
        return this.currentState.get();
    }

    public int clientCount() {
        return this.connectionPool.count();
    }
}

