/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent;

import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.TokenCacheNode;
import com.alibaba.csp.sentinel.cluster.flow.statistic.concurrent.expire.RegularExpireStrategy;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.util.Set;

public class TokenCacheNodeManager {
    private static ConcurrentLinkedHashMap<Long, TokenCacheNode> TOKEN_CACHE_NODE_MAP;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final int DEFAULT_CAPACITY = Integer.MAX_VALUE;

    public static void prepare(int concurrencyLevel, int maximumWeightedCapacity) {
        AssertUtil.isTrue((concurrencyLevel > 0 ? 1 : 0) != 0, (String)"concurrencyLevel must be positive");
        AssertUtil.isTrue((maximumWeightedCapacity > 0 ? 1 : 0) != 0, (String)"maximumWeightedCapacity must be positive");
        TOKEN_CACHE_NODE_MAP = new ConcurrentLinkedHashMap.Builder().concurrencyLevel(concurrencyLevel).maximumWeightedCapacity((long)maximumWeightedCapacity).weigher(Weighers.singleton()).build();
        RegularExpireStrategy strategy = new RegularExpireStrategy(TOKEN_CACHE_NODE_MAP);
        strategy.startClearTaskRegularly();
    }

    public static TokenCacheNode getTokenCacheNode(long tokenId) {
        return (TokenCacheNode)TOKEN_CACHE_NODE_MAP.getQuietly((Object)tokenId);
    }

    public static void putTokenCacheNode(long tokenId, TokenCacheNode cacheNode) {
        TOKEN_CACHE_NODE_MAP.put((Object)tokenId, (Object)cacheNode);
    }

    public static boolean isContainsTokenId(long tokenId) {
        return TOKEN_CACHE_NODE_MAP.containsKey((Object)tokenId);
    }

    public static TokenCacheNode removeTokenCacheNode(long tokenId) {
        return (TokenCacheNode)TOKEN_CACHE_NODE_MAP.remove((Object)tokenId);
    }

    public static int getSize() {
        return TOKEN_CACHE_NODE_MAP.size();
    }

    public static Set<Long> getCacheKeySet() {
        return TOKEN_CACHE_NODE_MAP.keySet();
    }

    public static boolean validToken(TokenCacheNode cacheNode) {
        return cacheNode.getTokenId() != null && cacheNode.getFlowId() != null && cacheNode.getClientTimeout() >= 0L && cacheNode.getResourceTimeout() >= 0L;
    }

    static {
        TokenCacheNodeManager.prepare(16, Integer.MAX_VALUE);
    }
}

