/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.apollo;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;

public class ApolloDataSource<T>
extends AbstractDataSource<String, T> {
    private final Config config;
    private final String ruleKey;
    private final String defaultRuleValue;
    private ConfigChangeListener configChangeListener;

    public ApolloDataSource(String namespaceName, String ruleKey, String defaultRuleValue, Converter<String, T> parser) {
        super(parser);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespaceName) ? 1 : 0) != 0, (Object)"Namespace name could not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ruleKey) ? 1 : 0) != 0, (Object)"RuleKey could not be null or empty!");
        this.ruleKey = ruleKey;
        this.defaultRuleValue = defaultRuleValue;
        this.config = ConfigService.getConfig((String)namespaceName);
        this.initialize();
        RecordLog.info((String)String.format("Initialized rule for namespace: %s, rule key: %s", namespaceName, ruleKey), (Object[])new Object[0]);
    }

    private void initialize() {
        this.initializeConfigChangeListener();
        this.loadAndUpdateRules();
    }

    private void loadAndUpdateRules() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[ApolloDataSource] WARN: rule config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Throwable ex) {
            RecordLog.warn((String)"[ApolloDataSource] Error when loading rule config", (Throwable)ex);
        }
    }

    private void initializeConfigChangeListener() {
        this.configChangeListener = new ConfigChangeListener(){

            public void onChange(ConfigChangeEvent changeEvent) {
                ConfigChange change = changeEvent.getChange(ApolloDataSource.this.ruleKey);
                if (change != null) {
                    RecordLog.info((String)("[ApolloDataSource] Received config changes: " + change.toString()), (Object[])new Object[0]);
                }
                ApolloDataSource.this.loadAndUpdateRules();
            }
        };
        this.config.addChangeListener(this.configChangeListener, (Set)Sets.newHashSet((Object[])new String[]{this.ruleKey}));
    }

    public String readSource() throws Exception {
        return this.config.getProperty(this.ruleKey, this.defaultRuleValue);
    }

    public void close() throws Exception {
        this.config.removeChangeListener(this.configChangeListener);
    }
}

