/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.nacos;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.ConfigParser;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NacosDataSource<T>
extends AbstractDataSource<String, T> {
    private static final int DEFAULT_TIMEOUT = 3000;
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("sentinel-nacos-ds-update"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final Listener configListener;
    private final String groupId;
    private final String dataId;
    private ConfigService configService = null;

    public NacosDataSource(final String serverAddr, final String groupId, final String dataId, ConfigParser<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], groupId=[%s], dataId=[%s]", serverAddr, groupId, dataId));
        }
        this.groupId = groupId;
        this.dataId = dataId;
        this.configListener = new Listener(){

            public Executor getExecutor() {
                return NacosDataSource.this.pool;
            }

            public void receiveConfigInfo(String configInfo) {
                RecordLog.info((String)String.format("[NacosDataSource] New property value received for (%s, %s, %s): %s", serverAddr, dataId, groupId, configInfo));
                Object newValue = NacosDataSource.this.parser.parse((Object)configInfo);
                NacosDataSource.this.getProperty().updateValue(newValue);
            }
        };
        this.initNacosListener(serverAddr);
        this.loadInitialConfig();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.info((String)"[NacosDataSource] WARN: initial config is null, you may have to check your data source");
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.info((String)"[NacosDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    private void initNacosListener(String serverAddr) {
        try {
            this.configService = NacosFactory.createConfigService((String)serverAddr);
            this.configService.addListener(this.dataId, this.groupId, this.configListener);
        }
        catch (Exception e) {
            RecordLog.info((String)"[NacosDataSource] Error occurred when initializing Nacos data source", (Throwable)e);
            e.printStackTrace();
        }
    }

    public String readSource() throws Exception {
        if (this.configService == null) {
            throw new IllegalStateException("Nacos config service has not been initialized or error occurred");
        }
        return this.configService.getConfig(this.dataId, this.groupId, 3000L);
    }

    public void close() {
        if (this.configService != null) {
            this.configService.removeListener(this.dataId, this.groupId, this.configListener);
        }
        this.pool.shutdownNow();
    }
}

