/*
 * Copyright 1999-2019 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.csp.sentinel.datasource.nacos;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;

/**
 * @author Eric Zhao
 */
public class NacosSharedDataSource {

    //private static final int DEFAULT_TIMEOUT = 3000;
    //
    //private final String groupId;
    //private final String dataId;
    //
    //private ConfigService configService;
    //private final Listener configListener;
    //
    //private Map<Class<?>, GenericMetadata<?>> metadataMap = new ConcurrentHashMap<>();
    //
    ///**
    // * Single-thread pool. Once the thread pool is blocked, we throw up the old task.
    // */
    //private final ExecutorService pool;
    //
    //NacosSharedDataSource(final String groupId, final String dataId, ConfigService configService) {
    //    AssertUtil.assertState(configService != null, "configService should not be null");
    //    AssertUtil.assertNotBlank(groupId, "groupId cannot be blank");
    //    AssertUtil.assertNotBlank(dataId, "dataId cannot be blank");
    //    this.groupId = groupId;
    //    this.dataId = dataId;
    //    this.configService = configService;
    //
    //    this.pool = new ThreadPoolExecutor(1, 1, 0, TimeUnit.MILLISECONDS,
    //        new ArrayBlockingQueue<Runnable>(1), new NamedThreadFactory("sentinel-nacos-ds-update-" + dataId),
    //        new ThreadPoolExecutor.DiscardOldestPolicy());
    //    this.configListener = new Listener() {
    //        @Override
    //        public Executor getExecutor() {
    //            return pool;
    //        }
    //
    //        @Override
    //        public void receiveConfigInfo(final String configInfo) {
    //            RecordLog.info("[NacosDataSource] New data received for (dataId: {0}, groupId: {1}): {2}",
    //                dataId, groupId, configInfo);
    //            try {
    //                T newValue = NacosSharedDataSource.this.parser.convert(configInfo);
    //                // Update the new value to the property.
    //                getProperty().updateValue(newValue);
    //            } catch (Exception ex) {
    //                RecordLog.warn("[NacosDataSource] Failed to parse data (dataId: {0}, groupId: {1})",
    //                    dataId, groupId, ex);
    //            }
    //        }
    //    };
    //}
    //
    //@Override
    //public String readSource() throws Exception {
    //    if (configService == null) {
    //        throw new IllegalStateException("Nacos config service has not been initialized or already closed");
    //    }
    //    return configService.getConfig(dataId, groupId, DEFAULT_TIMEOUT);
    //}
    //
    //@Override
    //public void close() throws Exception {
    //    if (configService != null) {
    //        configService.removeListener(dataId, groupId, configListener);
    //        configService = null;
    //    }
    //    pool.shutdownNow();
    //}

    private static class GenericMetadata<T> {
        private final Class<T> clazz;
        private final Converter<String, T> converter;
        private final SentinelProperty<T> property;

        public GenericMetadata(Class<T> clazz, Converter<String, T> converter,
                               SentinelProperty<T> property) {
            this.clazz = clazz;
            this.converter = converter;
            this.property = property;
        }

        public Class<T> getClazz() {
            return clazz;
        }

        public Converter<String, T> getConverter() {
            return converter;
        }

        public SentinelProperty<T> getProperty() {
            return property;
        }
    }
}
