/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.zookeeper;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZookeeperDataSource<T>
extends AbstractDataSource<String, T> {
    private static final int RETRY_TIMES = 3;
    private static final int SLEEP_TIME = 1000;
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("sentinel-zookeeper-ds-update"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private NodeCacheListener listener;
    private final String path;
    private CuratorFramework zkClient = null;
    private NodeCache nodeCache = null;

    public ZookeeperDataSource(String serverAddr, String path, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)path)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], path=[%s]", serverAddr, path));
        }
        this.path = path;
        this.init(serverAddr);
    }

    public ZookeeperDataSource(String serverAddr, String groupId, String dataId, Converter<String, T> parser) {
        super(parser);
        if (StringUtil.isBlank((String)serverAddr) || StringUtil.isBlank((String)groupId) || StringUtil.isBlank((String)dataId)) {
            throw new IllegalArgumentException(String.format("Bad argument: serverAddr=[%s], groupId=[%s], dataId=[%s]", serverAddr, groupId, dataId));
        }
        this.path = this.getPath(groupId, dataId);
        this.init(serverAddr);
    }

    private void init(String serverAddr) {
        this.initZookeeperListener(serverAddr);
        this.loadInitialConfig();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[ZookeeperDataSource] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    private void initZookeeperListener(final String serverAddr) {
        try {
            this.listener = new NodeCacheListener(){

                public void nodeChanged() {
                    String configInfo = null;
                    ChildData childData = ZookeeperDataSource.this.nodeCache.getCurrentData();
                    if (null != childData && childData.getData() != null) {
                        configInfo = new String(childData.getData());
                    }
                    RecordLog.info((String)String.format("[ZookeeperDataSource] New property value received for (%s, %s): %s", serverAddr, ZookeeperDataSource.this.path, configInfo), (Object[])new Object[0]);
                    Object newValue = ZookeeperDataSource.this.parser.convert((Object)configInfo);
                    ZookeeperDataSource.this.getProperty().updateValue(newValue);
                }
            };
            this.zkClient = CuratorFrameworkFactory.newClient((String)serverAddr, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
            this.zkClient.start();
            Stat stat = (Stat)this.zkClient.checkExists().forPath(this.path);
            if (stat == null) {
                ((ACLBackgroundPathAndBytesable)this.zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.path, null);
            }
            this.nodeCache = new NodeCache(this.zkClient, this.path);
            this.nodeCache.getListenable().addListener((Object)this.listener, (Executor)this.pool);
            this.nodeCache.start();
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ZookeeperDataSource] Error occurred when initializing Zookeeper data source", (Throwable)e);
            e.printStackTrace();
        }
    }

    public String readSource() throws Exception {
        if (this.zkClient == null) {
            throw new IllegalStateException("Zookeeper has not been initialized or error occurred");
        }
        byte[] data = (byte[])this.zkClient.getData().forPath(this.path);
        if (data != null) {
            return new String(data);
        }
        return null;
    }

    public void close() throws Exception {
        if (this.nodeCache != null) {
            this.nodeCache.getListenable().removeListener((Object)this.listener);
            this.nodeCache.close();
        }
        if (this.zkClient != null) {
            this.zkClient.close();
        }
        this.pool.shutdown();
    }

    private String getPath(String groupId, String dataId) {
        return String.format("/%s/%s", groupId, dataId);
    }
}

