/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.jaxrs;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.jaxrs.config.SentinelJaxRsConfig;
import com.alibaba.csp.sentinel.adapter.jaxrs.future.FutureWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.function.Supplier;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;

public class SentinelJaxRsClientTemplate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response execute(String resourceName, Supplier<Response> supplier) {
        Entry entry = null;
        try {
            entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.OUT);
            Response response = (Response)supplier.get();
            return response;
        }
        catch (BlockException ex) {
            Response response = SentinelJaxRsConfig.getJaxRsFallback().fallbackResponse(resourceName, ex);
            return response;
        }
        finally {
            System.out.println("entry exit");
            if (entry != null) {
                entry.exit();
            }
        }
    }

    public static Future<Response> executeAsync(String resourceName, Supplier<Future<Response>> supplier) {
        try {
            AsyncEntry entry = SphU.asyncEntry((String)resourceName, (int)1, (EntryType)EntryType.OUT);
            return new FutureWrapper<Response>(entry, (Future)supplier.get());
        }
        catch (BlockException ex) {
            return SentinelJaxRsConfig.getJaxRsFallback().fallbackFutureResponse(resourceName, ex);
        }
    }
}

