/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.jaxrs;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.jaxrs.config.SentinelJaxRsConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
public class SentinelJaxRsProviderFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String SENTINEL_JAX_RS_PROVIDER_CONTEXT_NAME = "sentinel_jax_rs_provider_context";
    private static final String SENTINEL_JAX_RS_PROVIDER_ENTRY_PROPERTY = "sentinel_jax_rs_provider_entry_property";
    @Context
    private ResourceInfo resourceInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        try {
            String resourceName = this.getResourceName(containerRequestContext, this.resourceInfo);
            if (StringUtil.isNotEmpty((String)resourceName)) {
                String origin = this.parseOrigin(containerRequestContext);
                String contextName = this.getContextName(containerRequestContext);
                ContextUtil.enter((String)contextName, (String)origin);
                Entry entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN);
                containerRequestContext.setProperty(SENTINEL_JAX_RS_PROVIDER_ENTRY_PROPERTY, (Object)entry);
            }
        }
        catch (BlockException e) {
            try {
                containerRequestContext.abortWith(SentinelJaxRsConfig.getJaxRsFallback().fallbackResponse(containerRequestContext.getUriInfo().getPath(), e));
            }
            finally {
                ContextUtil.exit();
            }
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        Entry entry = (Entry)containerRequestContext.getProperty(SENTINEL_JAX_RS_PROVIDER_ENTRY_PROPERTY);
        if (entry != null) {
            entry.exit();
        }
        containerRequestContext.removeProperty(SENTINEL_JAX_RS_PROVIDER_ENTRY_PROPERTY);
        ContextUtil.exit();
    }

    public String getResourceName(ContainerRequestContext containerRequestContext, ResourceInfo resourceInfo) {
        return SentinelJaxRsConfig.getResourceNameParser().parse(containerRequestContext, resourceInfo);
    }

    protected String getContextName(ContainerRequestContext request) {
        return SENTINEL_JAX_RS_PROVIDER_CONTEXT_NAME;
    }

    protected String parseOrigin(ContainerRequestContext request) {
        return SentinelJaxRsConfig.getRequestOriginParser().parseOrigin(request);
    }
}

