/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command.http;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.transport.command.SimpleHttpCommandCenter;
import com.alibaba.csp.sentinel.transport.command.exception.RequestException;
import com.alibaba.csp.sentinel.transport.command.http.StatusCode;
import com.alibaba.csp.sentinel.transport.log.CommandCenterLog;
import com.alibaba.csp.sentinel.transport.util.HttpCommandUtils;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class HttpEventTask
implements Runnable {
    public static final String SERVER_ERROR_MESSAGE = "Command server error";
    public static final String INVALID_COMMAND_MESSAGE = "Invalid command";
    private final Socket socket;
    private boolean writtenHead = false;

    public HttpEventTask(Socket socket) {
        this.socket = socket;
    }

    public void close() throws Exception {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        String commandName;
        CommandRequest request;
        String firstLine;
        long start;
        BufferedInputStream inputStream;
        PrintWriter printWriter;
        block16: {
            if (this.socket == null) {
                return;
            }
            printWriter = null;
            inputStream = null;
            start = System.currentTimeMillis();
            inputStream = new BufferedInputStream(this.socket.getInputStream());
            OutputStream outputStream = this.socket.getOutputStream();
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, Charset.forName(SentinelConfig.charset())));
            firstLine = HttpEventTask.readLine(inputStream);
            CommandCenterLog.info((String)("[SimpleHttpCommandCenter] Socket income: " + firstLine + ", addr: " + this.socket.getInetAddress()), (Object[])new Object[0]);
            request = HttpEventTask.processQueryString(firstLine);
            if (firstLine.length() > 4 && StringUtil.equalsIgnoreCase((CharSequence)"POST", (CharSequence)firstLine.substring(0, 4))) {
                HttpEventTask.processPostRequest(inputStream, request);
            }
            if (!StringUtil.isBlank((String)(commandName = HttpCommandUtils.getTarget((CommandRequest)request)))) break block16;
            this.writeResponse(printWriter, StatusCode.BAD_REQUEST, INVALID_COMMAND_MESSAGE);
            this.closeResource(inputStream);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
            return;
        }
        try {
            CommandHandler commandHandler = SimpleHttpCommandCenter.getHandler(commandName);
            if (commandHandler != null) {
                CommandResponse response = commandHandler.handle(request);
                this.handleResponse(response, printWriter);
            } else {
                this.writeResponse(printWriter, StatusCode.BAD_REQUEST, "Unknown command `" + commandName + '`');
            }
            long cost = System.currentTimeMillis() - start;
            CommandCenterLog.info((String)("[SimpleHttpCommandCenter] Deal a socket task: " + firstLine + ", address: " + this.socket.getInetAddress() + ", time cost: " + cost + " ms"), (Object[])new Object[0]);
            this.closeResource(inputStream);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
        }
        catch (RequestException e) {
            this.writeResponse(printWriter, e.getStatusCode(), e.getMessage());
            this.closeResource(inputStream);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
        }
        catch (Throwable e2) {
            CommandCenterLog.warn((String)"[SimpleHttpCommandCenter] CommandCenter error", (Throwable)e2);
            try {
                if (printWriter != null) {
                    String errorMessage = SERVER_ERROR_MESSAGE;
                    e2.printStackTrace();
                    if (!this.writtenHead) {
                        this.writeResponse(printWriter, StatusCode.INTERNAL_SERVER_ERROR, errorMessage);
                    } else {
                        printWriter.println(errorMessage);
                    }
                    printWriter.flush();
                }
            }
            catch (Exception e1) {
                CommandCenterLog.warn((String)"Failed to write error response", (Throwable)e1);
            }
            this.closeResource(inputStream);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
            {
                catch (Throwable throwable) {
                    this.closeResource(inputStream);
                    this.closeResource(printWriter);
                    this.closeResource(this.socket);
                    throw throwable;
                }
            }
        }
    }

    private static String readLine(InputStream in) throws IOException {
        int data;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        while ((data = in.read()) >= 0 && data != 10) {
            bos.write(data);
        }
        byte[] arr = bos.toByteArray();
        if (arr.length > 0 && arr[arr.length - 1] == 13) {
            return new String(arr, 0, arr.length - 1, SentinelConfig.charset());
        }
        return new String(arr, SentinelConfig.charset());
    }

    protected static void processPostRequest(InputStream in, CommandRequest request) throws RequestException, IOException {
        Map<String, String> headerMap = HttpEventTask.parsePostHeaders(in);
        if (headerMap == null) {
            CommandCenterLog.warn((String)"Illegal request read: null headerMap", (Object[])new Object[0]);
            throw new RequestException(StatusCode.BAD_REQUEST, "");
        }
        if (headerMap.containsKey("content-type") && !HttpEventTask.checkContentTypeSupported(headerMap.get("content-type"))) {
            CommandCenterLog.warn((String)("Request not supported: unsupported Content-Type: " + headerMap.get("content-type")), (Object[])new Object[0]);
            throw new RequestException(StatusCode.UNSUPPORTED_MEDIA_TYPE, "Only form-encoded post request is supported");
        }
        int bodyLength = 0;
        try {
            bodyLength = Integer.parseInt(headerMap.get("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bodyLength < 1) {
            CommandCenterLog.warn((String)"Request not supported: no available Content-Length in headers", (Object[])new Object[0]);
            throw new RequestException(StatusCode.LENGTH_REQUIRED, "No legal Content-Length");
        }
        HttpEventTask.parseParams(HttpEventTask.readBody(in, bodyLength), request);
    }

    protected static Map<String, String> parsePostHeaders(InputStream in) throws IOException {
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        String line;
        while ((line = HttpEventTask.readLine(in)) != null && line.length() != 0) {
            int index = line.indexOf(":");
            if (index < 1) continue;
            String headerName = line.substring(0, index).trim().toLowerCase();
            String headerValue = line.substring(index + 1).trim();
            if (headerValue.length() <= 0) continue;
            headerMap.put(headerName, headerValue);
        }
        return headerMap;
    }

    private static boolean checkContentTypeSupported(String contentType) {
        int idx = contentType.indexOf(";");
        String type = idx > 0 ? contentType.substring(0, idx).toLowerCase().trim() : contentType.toLowerCase();
        return type.contains("application/x-www-form-urlencoded");
    }

    private static String readBody(InputStream in, int bodyLength) throws IOException, RequestException {
        int l;
        byte[] buf = new byte[bodyLength];
        int pos = 0;
        while (pos < bodyLength && (l = in.read(buf, pos, Math.min(512, bodyLength - pos))) >= 0) {
            if (l == 0) continue;
            pos += l;
        }
        return new String(buf, 0, pos, SentinelConfig.charset());
    }

    protected static void parseParams(String queryString, CommandRequest request) {
        if (queryString == null || queryString.length() < 1) {
            return;
        }
        int offset = 0;
        int pos = -1;
        queryString = HttpEventTask.removeAnchor(queryString);
        while (true) {
            if ((offset = pos + 1) == (pos = queryString.indexOf(38, offset))) {
                continue;
            }
            HttpEventTask.parseSingleParam(queryString.substring(offset, pos == -1 ? queryString.length() : pos), request);
            if (pos < 0) break;
        }
    }

    private void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                CommandCenterLog.warn((String)"[SimpleHttpCommandCenter] Close resource failed", (Throwable)e);
            }
        }
    }

    private <T> void handleResponse(CommandResponse<T> response, PrintWriter printWriter) throws Exception {
        if (response.isSuccess()) {
            if (response.getResult() == null) {
                this.writeResponse(printWriter, StatusCode.OK, null);
                return;
            }
            byte[] buffer = response.getResult().toString().getBytes(SentinelConfig.charset());
            this.writeResponse(printWriter, StatusCode.OK, new String(buffer));
        } else {
            String msg = SERVER_ERROR_MESSAGE;
            if (response.getException() != null) {
                msg = response.getException().getMessage();
            }
            this.writeResponse(printWriter, StatusCode.BAD_REQUEST, msg);
        }
    }

    private void writeResponse(PrintWriter out, StatusCode statusCode, String message) {
        out.print("HTTP/1.0 " + statusCode.toString() + "\r\nContent-Length: " + (message == null ? 0 : message.getBytes().length) + "\r\nConnection: close\r\n\r\n");
        if (message != null) {
            out.print(message);
        }
        out.flush();
        this.writtenHead = true;
    }

    protected static CommandRequest processQueryString(String line) {
        CommandRequest request = new CommandRequest();
        if (StringUtil.isBlank((String)line)) {
            return request;
        }
        int start = line.indexOf(47);
        int ask = line.indexOf(63) == -1 ? line.lastIndexOf(32) : line.indexOf(63);
        int space = line.lastIndexOf(32);
        String target = line.substring(start != -1 ? start + 1 : 0, ask != -1 ? ask : line.length());
        request.addMetadata("command-target", target);
        if (ask == -1 || ask == space) {
            return request;
        }
        String parameterStr = line.substring(ask != -1 ? ask + 1 : 0, space != -1 ? space : line.length());
        HttpEventTask.parseParams(parameterStr, request);
        return request;
    }

    protected static String removeAnchor(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int anchor = str.indexOf(35);
        if (anchor == 0) {
            return "";
        }
        if (anchor > 0) {
            return str.substring(0, anchor);
        }
        return str;
    }

    protected static void parseSingleParam(String single, CommandRequest request) {
        if (single == null || single.length() < 3) {
            return;
        }
        int index = single.indexOf(61);
        if (index <= 0 || index >= single.length() - 1) {
            return;
        }
        String value = StringUtil.trim((String)single.substring(index + 1));
        String key = StringUtil.trim((String)single.substring(0, index));
        try {
            key = URLDecoder.decode(key, SentinelConfig.charset());
            value = URLDecoder.decode(value, SentinelConfig.charset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        request.addParam(key, value);
    }
}

