/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandHandlerProvider;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.transport.CommandCenter;
import com.alibaba.csp.sentinel.transport.command.http.HttpEventTask;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.transport.log.CommandCenterLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimpleHttpCommandCenter
implements CommandCenter {
    private static final int PORT_UNINITIALIZED = -1;
    private static final int DEFAULT_SERVER_SO_TIMEOUT = 3000;
    private static final int DEFAULT_PORT = 8719;
    private static final Map<String, CommandHandler> handlerMap = new ConcurrentHashMap<String, CommandHandler>();
    private ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("sentinel-command-center-executor", true));
    private ExecutorService bizExecutor;
    private ServerSocket socketReference;

    public void beforeStart() throws Exception {
        Map handlers = CommandHandlerProvider.getInstance().namedHandlers();
        SimpleHttpCommandCenter.registerCommands(handlers);
    }

    public void start() throws Exception {
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.bizExecutor = new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), (ThreadFactory)new NamedThreadFactory("sentinel-command-center-service-executor", true), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                CommandCenterLog.info((String)"EventTask rejected", (Object[])new Object[0]);
                throw new RejectedExecutionException();
            }
        });
        Runnable serverInitTask = new Runnable(){
            int port;
            {
                try {
                    this.port = Integer.parseInt(TransportConfig.getPort());
                }
                catch (Exception e) {
                    this.port = 8719;
                }
            }

            @Override
            public void run() {
                boolean success = false;
                ServerSocket serverSocket = SimpleHttpCommandCenter.getServerSocketFromBasePort(this.port);
                if (serverSocket != null) {
                    CommandCenterLog.info((String)("[CommandCenter] Begin listening at port " + serverSocket.getLocalPort()), (Object[])new Object[0]);
                    SimpleHttpCommandCenter.this.socketReference = serverSocket;
                    SimpleHttpCommandCenter.this.executor.submit(new ServerThread(serverSocket));
                    success = true;
                    this.port = serverSocket.getLocalPort();
                } else {
                    CommandCenterLog.info((String)"[CommandCenter] chooses port fail, http command center will not work", (Object[])new Object[0]);
                }
                if (!success) {
                    this.port = -1;
                }
                TransportConfig.setRuntimePort((int)this.port);
                SimpleHttpCommandCenter.this.executor.shutdown();
            }
        };
        new Thread(serverInitTask).start();
    }

    private static ServerSocket getServerSocketFromBasePort(int basePort) {
        int tryCount = 0;
        while (true) {
            try {
                ServerSocket server = new ServerSocket(basePort + tryCount / 3, 100);
                server.setReuseAddress(true);
                return server;
            }
            catch (IOException e) {
                ++tryCount;
                try {
                    TimeUnit.MILLISECONDS.sleep(30L);
                }
                catch (InterruptedException e1) {
                    return null;
                }
            }
        }
    }

    public void stop() throws Exception {
        if (this.socketReference != null) {
            try {
                this.socketReference.close();
            }
            catch (IOException e) {
                CommandCenterLog.warn((String)"Error when releasing the server socket", (Throwable)e);
            }
        }
        if (this.bizExecutor != null) {
            this.bizExecutor.shutdownNow();
        }
        this.executor.shutdownNow();
        TransportConfig.setRuntimePort((int)-1);
        handlerMap.clear();
    }

    public static Set<String> getCommands() {
        return handlerMap.keySet();
    }

    public static CommandHandler getHandler(String commandName) {
        return handlerMap.get(commandName);
    }

    public static void registerCommands(Map<String, CommandHandler> handlerMap) {
        if (handlerMap != null) {
            for (Map.Entry<String, CommandHandler> e : handlerMap.entrySet()) {
                SimpleHttpCommandCenter.registerCommand(e.getKey(), e.getValue());
            }
        }
    }

    public static void registerCommand(String commandName, CommandHandler handler) {
        if (StringUtil.isEmpty((String)commandName)) {
            return;
        }
        if (handlerMap.containsKey(commandName)) {
            CommandCenterLog.warn((String)("Register failed (duplicate command): " + commandName), (Object[])new Object[0]);
            return;
        }
        handlerMap.put(commandName, handler);
    }

    private void setSocketSoTimeout(Socket socket) throws SocketException {
        if (socket != null) {
            socket.setSoTimeout(3000);
        }
    }

    class ServerThread
    extends Thread {
        private ServerSocket serverSocket;

        ServerThread(ServerSocket s) {
            this.serverSocket = s;
            this.setName("sentinel-courier-server-accept-thread");
        }

        @Override
        public void run() {
            while (true) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    SimpleHttpCommandCenter.this.setSocketSoTimeout(socket);
                    HttpEventTask eventTask = new HttpEventTask(socket);
                    SimpleHttpCommandCenter.this.bizExecutor.submit(eventTask);
                }
                catch (Exception e) {
                    CommandCenterLog.info((String)"Server error", (Throwable)e);
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception e1) {
                            CommandCenterLog.info((String)"Error when closing an opened socket", (Throwable)e1);
                        }
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e1) {
                        return;
                    }
                }
            }
        }
    }
}

