/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.api.matcher;

import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPathPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.matcher.AbstractApiMatcher;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.api.route.ZuulRouteMatchers;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.netflix.zuul.context.RequestContext;

public class RequestContextApiMatcher
extends AbstractApiMatcher<RequestContext> {
    public RequestContextApiMatcher(ApiDefinition apiDefinition) {
        super(apiDefinition);
    }

    protected void initializeMatchers() {
        if (this.apiDefinition.getPredicateItems() != null) {
            for (ApiPredicateItem item : this.apiDefinition.getPredicateItems()) {
                Predicate<RequestContext> predicate = this.fromApiPredicate(item);
                if (predicate == null) continue;
                this.matchers.add(predicate);
            }
        }
    }

    private Predicate<RequestContext> fromApiPredicate(ApiPredicateItem item) {
        if (item instanceof ApiPathPredicateItem) {
            return this.fromApiPathPredicate((ApiPathPredicateItem)item);
        }
        return null;
    }

    private Predicate<RequestContext> fromApiPathPredicate(ApiPathPredicateItem item) {
        String pattern = item.getPattern();
        if (StringUtil.isBlank((String)pattern)) {
            return null;
        }
        switch (item.getMatchStrategy()) {
            case 2: {
                return ZuulRouteMatchers.regexPath(pattern);
            }
            case 1: {
                return ZuulRouteMatchers.antPath(pattern);
            }
        }
        return ZuulRouteMatchers.exactPath(pattern);
    }
}

