/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.zuul.filters;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.gateway.common.param.GatewayParamParser;
import com.alibaba.csp.sentinel.adapter.gateway.common.param.RequestItemParser;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.RequestContextItemParser;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.api.ZuulGatewayApiMatcherManager;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.api.matcher.RequestContextApiMatcher;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.callback.ZuulGatewayCallbackManager;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.fallback.BlockResponse;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.fallback.ZuulBlockFallbackManager;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.fallback.ZuulBlockFallbackProvider;
import com.alibaba.csp.sentinel.adapter.gateway.zuul.filters.EntryHolder;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SentinelZuulPreFilter
extends ZuulFilter {
    private final int order;
    private final GatewayParamParser<RequestContext> paramParser = new GatewayParamParser((RequestItemParser)new RequestContextItemParser());

    public SentinelZuulPreFilter() {
        this(10000);
    }

    public SentinelZuulPreFilter(int order) {
        this.order = order;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return this.order;
    }

    public boolean shouldFilter() {
        return true;
    }

    private void doSentinelEntry(String resourceName, final int resType, RequestContext requestContext, Deque<EntryHolder> holders) throws BlockException {
        Object[] params = this.paramParser.parseParameterFor(resourceName, (Object)requestContext, (Predicate)new Predicate<GatewayFlowRule>(){

            public boolean test(GatewayFlowRule r) {
                return r.getResourceMode() == resType;
            }
        });
        AsyncEntry entry = SphU.asyncEntry((String)resourceName, (int)3, (EntryType)EntryType.IN, (Object[])params);
        EntryHolder holder = new EntryHolder((Entry)entry, params);
        holders.push(holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() throws ZuulException {
        RequestContext ctx = RequestContext.getCurrentContext();
        String origin = this.parseOrigin(ctx.getRequest());
        String routeId = (String)ctx.get((Object)"proxy");
        ArrayDeque<EntryHolder> holders = new ArrayDeque<EntryHolder>();
        String fallBackRoute = routeId;
        try {
            Set<String> matchingApis;
            if (StringUtil.isNotBlank((String)routeId)) {
                ContextUtil.enter((String)("sentinel_gateway_context$$route$$" + routeId), (String)origin);
                this.doSentinelEntry(routeId, 0, ctx, holders);
            }
            if (!(matchingApis = this.pickMatchingApiDefinitions(ctx)).isEmpty() && ContextUtil.getContext() == null) {
                ContextUtil.enter((String)"zuul_default_context", (String)origin);
            }
            Iterator<String> iterator = matchingApis.iterator();
            while (iterator.hasNext()) {
                String apiName;
                fallBackRoute = apiName = iterator.next();
                this.doSentinelEntry(apiName, 1, ctx, holders);
            }
        }
        catch (BlockException ex) {
            ZuulBlockFallbackProvider zuulBlockFallbackProvider = ZuulBlockFallbackManager.getFallbackProvider(fallBackRoute);
            BlockResponse blockResponse = zuulBlockFallbackProvider.fallbackResponse(fallBackRoute, ex);
            ctx.setRouteHost(null);
            ctx.set("serviceId", null);
            ctx.setResponseBody(blockResponse.toString());
            ctx.setResponseStatusCode(blockResponse.getCode());
            ctx.getResponse().setContentType("application/json; charset=utf-8");
        }
        finally {
            if (!holders.isEmpty()) {
                ctx.put((Object)"_sentinel_entries", holders);
            }
        }
        return null;
    }

    private String parseOrigin(HttpServletRequest request) {
        return ZuulGatewayCallbackManager.getOriginParser().parseOrigin(request);
    }

    private Set<String> pickMatchingApiDefinitions(RequestContext requestContext) {
        HashSet<String> apis = new HashSet<String>();
        for (RequestContextApiMatcher matcher : ZuulGatewayApiMatcherManager.getApiMatcherMap().values()) {
            if (!matcher.test(requestContext)) continue;
            apis.add(matcher.getApiName());
        }
        return apis;
    }
}

