/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.transcription;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscriptionParam
extends HalfDuplexServiceParam {
    private static final Logger log = LoggerFactory.getLogger(TranscriptionParam.class);
    @NonNull
    private List<String> fileUrls;
    private String phraseId;
    private List<Integer> channelId;
    private Boolean diarizationEnabled;
    private Integer speakerCount;
    private Boolean disfluencyRemovalEnabled;
    private Boolean timestampAlignmentEnabled;
    private String specialWordFilter;
    private Boolean audioEventDetectionEnabled;

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.addProperty("model", this.getModel());
        JsonArray jsonFileUrls = new JsonArray();
        for (String string : this.fileUrls) {
            jsonFileUrls.add(string);
        }
        JsonArray jsonChannelId = new JsonArray();
        if (this.channelId == null) {
            this.channelId = Collections.singletonList(0);
        }
        for (Integer id : this.channelId) {
            jsonChannelId.add((Number)id);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("file_urls", (JsonElement)jsonFileUrls);
        body.add("input", (JsonElement)jsonObject);
        JsonObject jsonParameters = JsonUtils.parametersToJsonObject(this.getParameters());
        jsonParameters.add("channel_id", (JsonElement)jsonChannelId);
        if (this.diarizationEnabled != null) {
            jsonParameters.addProperty("diarization_enabled", this.diarizationEnabled);
        }
        if (this.speakerCount != null) {
            jsonParameters.addProperty("speaker_count", (Number)this.speakerCount);
        }
        if (this.disfluencyRemovalEnabled != null) {
            jsonParameters.addProperty("disfluency_removal_enabled", this.disfluencyRemovalEnabled);
        }
        if (this.timestampAlignmentEnabled != null) {
            jsonParameters.addProperty("timestamp_alignment_enabled", this.timestampAlignmentEnabled);
        }
        if (this.specialWordFilter != null) {
            jsonParameters.addProperty("special_word_filter", this.specialWordFilter);
        }
        if (this.audioEventDetectionEnabled != null) {
            jsonParameters.addProperty("audio_event_detection_enabled", this.audioEventDetectionEnabled);
        }
        body.add("parameters", (JsonElement)jsonParameters);
        if (this.phraseId != null) {
            JsonArray jsonResources = new JsonArray();
            JsonObject jsonPhraseResource = new JsonObject();
            jsonPhraseResource.addProperty("resource_id", this.phraseId);
            jsonPhraseResource.addProperty("resource_type", "asr_phrase");
            jsonResources.getAsJsonArray().add((JsonElement)jsonPhraseResource);
            body.add("resources", (JsonElement)jsonResources);
        }
        log.info("body=>{}", (Object)body);
        return body;
    }

    @Override
    public Object getInput() {
        JsonArray jsonFileUrls = new JsonArray();
        for (String fileUrl : this.fileUrls) {
            jsonFileUrls.add(fileUrl);
        }
        JsonObject jsonInput = new JsonObject();
        jsonInput.add("file_urls", (JsonElement)jsonFileUrls);
        return jsonInput;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    private static List<Integer> $default$channelId() {
        return Collections.singletonList(0);
    }

    protected TranscriptionParam(TranscriptionParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.fileUrls = ((TranscriptionParamBuilder)b).fileUrls;
        if (this.fileUrls == null) {
            throw new NullPointerException("fileUrls is marked non-null but is null");
        }
        this.phraseId = ((TranscriptionParamBuilder)b).phraseId;
        this.channelId = ((TranscriptionParamBuilder)b).channelId$set ? ((TranscriptionParamBuilder)b).channelId$value : TranscriptionParam.$default$channelId();
        this.diarizationEnabled = ((TranscriptionParamBuilder)b).diarizationEnabled;
        this.speakerCount = ((TranscriptionParamBuilder)b).speakerCount;
        this.disfluencyRemovalEnabled = ((TranscriptionParamBuilder)b).disfluencyRemovalEnabled;
        this.timestampAlignmentEnabled = ((TranscriptionParamBuilder)b).timestampAlignmentEnabled;
        this.specialWordFilter = ((TranscriptionParamBuilder)b).specialWordFilter;
        this.audioEventDetectionEnabled = ((TranscriptionParamBuilder)b).audioEventDetectionEnabled;
    }

    public static TranscriptionParamBuilder<?, ?> builder() {
        return new TranscriptionParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranscriptionParam)) {
            return false;
        }
        TranscriptionParam other = (TranscriptionParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$diarizationEnabled = this.getDiarizationEnabled();
        Boolean other$diarizationEnabled = other.getDiarizationEnabled();
        if (this$diarizationEnabled == null ? other$diarizationEnabled != null : !((Object)this$diarizationEnabled).equals(other$diarizationEnabled)) {
            return false;
        }
        Integer this$speakerCount = this.getSpeakerCount();
        Integer other$speakerCount = other.getSpeakerCount();
        if (this$speakerCount == null ? other$speakerCount != null : !((Object)this$speakerCount).equals(other$speakerCount)) {
            return false;
        }
        Boolean this$disfluencyRemovalEnabled = this.getDisfluencyRemovalEnabled();
        Boolean other$disfluencyRemovalEnabled = other.getDisfluencyRemovalEnabled();
        if (this$disfluencyRemovalEnabled == null ? other$disfluencyRemovalEnabled != null : !((Object)this$disfluencyRemovalEnabled).equals(other$disfluencyRemovalEnabled)) {
            return false;
        }
        Boolean this$timestampAlignmentEnabled = this.getTimestampAlignmentEnabled();
        Boolean other$timestampAlignmentEnabled = other.getTimestampAlignmentEnabled();
        if (this$timestampAlignmentEnabled == null ? other$timestampAlignmentEnabled != null : !((Object)this$timestampAlignmentEnabled).equals(other$timestampAlignmentEnabled)) {
            return false;
        }
        Boolean this$audioEventDetectionEnabled = this.getAudioEventDetectionEnabled();
        Boolean other$audioEventDetectionEnabled = other.getAudioEventDetectionEnabled();
        if (this$audioEventDetectionEnabled == null ? other$audioEventDetectionEnabled != null : !((Object)this$audioEventDetectionEnabled).equals(other$audioEventDetectionEnabled)) {
            return false;
        }
        List<String> this$fileUrls = this.getFileUrls();
        List<String> other$fileUrls = other.getFileUrls();
        if (this$fileUrls == null ? other$fileUrls != null : !((Object)this$fileUrls).equals(other$fileUrls)) {
            return false;
        }
        String this$phraseId = this.getPhraseId();
        String other$phraseId = other.getPhraseId();
        if (this$phraseId == null ? other$phraseId != null : !this$phraseId.equals(other$phraseId)) {
            return false;
        }
        List<Integer> this$channelId = this.getChannelId();
        List<Integer> other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !((Object)this$channelId).equals(other$channelId)) {
            return false;
        }
        String this$specialWordFilter = this.getSpecialWordFilter();
        String other$specialWordFilter = other.getSpecialWordFilter();
        return !(this$specialWordFilter == null ? other$specialWordFilter != null : !this$specialWordFilter.equals(other$specialWordFilter));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TranscriptionParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $diarizationEnabled = this.getDiarizationEnabled();
        result = result * 59 + ($diarizationEnabled == null ? 43 : ((Object)$diarizationEnabled).hashCode());
        Integer $speakerCount = this.getSpeakerCount();
        result = result * 59 + ($speakerCount == null ? 43 : ((Object)$speakerCount).hashCode());
        Boolean $disfluencyRemovalEnabled = this.getDisfluencyRemovalEnabled();
        result = result * 59 + ($disfluencyRemovalEnabled == null ? 43 : ((Object)$disfluencyRemovalEnabled).hashCode());
        Boolean $timestampAlignmentEnabled = this.getTimestampAlignmentEnabled();
        result = result * 59 + ($timestampAlignmentEnabled == null ? 43 : ((Object)$timestampAlignmentEnabled).hashCode());
        Boolean $audioEventDetectionEnabled = this.getAudioEventDetectionEnabled();
        result = result * 59 + ($audioEventDetectionEnabled == null ? 43 : ((Object)$audioEventDetectionEnabled).hashCode());
        List<String> $fileUrls = this.getFileUrls();
        result = result * 59 + ($fileUrls == null ? 43 : ((Object)$fileUrls).hashCode());
        String $phraseId = this.getPhraseId();
        result = result * 59 + ($phraseId == null ? 43 : $phraseId.hashCode());
        List<Integer> $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : ((Object)$channelId).hashCode());
        String $specialWordFilter = this.getSpecialWordFilter();
        result = result * 59 + ($specialWordFilter == null ? 43 : $specialWordFilter.hashCode());
        return result;
    }

    @NonNull
    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    public String getPhraseId() {
        return this.phraseId;
    }

    public List<Integer> getChannelId() {
        return this.channelId;
    }

    public Boolean getDiarizationEnabled() {
        return this.diarizationEnabled;
    }

    public Integer getSpeakerCount() {
        return this.speakerCount;
    }

    public Boolean getDisfluencyRemovalEnabled() {
        return this.disfluencyRemovalEnabled;
    }

    public Boolean getTimestampAlignmentEnabled() {
        return this.timestampAlignmentEnabled;
    }

    public String getSpecialWordFilter() {
        return this.specialWordFilter;
    }

    public Boolean getAudioEventDetectionEnabled() {
        return this.audioEventDetectionEnabled;
    }

    public void setFileUrls(@NonNull List<String> fileUrls) {
        if (fileUrls == null) {
            throw new NullPointerException("fileUrls is marked non-null but is null");
        }
        this.fileUrls = fileUrls;
    }

    public void setPhraseId(String phraseId) {
        this.phraseId = phraseId;
    }

    public void setChannelId(List<Integer> channelId) {
        this.channelId = channelId;
    }

    public void setDiarizationEnabled(Boolean diarizationEnabled) {
        this.diarizationEnabled = diarizationEnabled;
    }

    public void setSpeakerCount(Integer speakerCount) {
        this.speakerCount = speakerCount;
    }

    public void setDisfluencyRemovalEnabled(Boolean disfluencyRemovalEnabled) {
        this.disfluencyRemovalEnabled = disfluencyRemovalEnabled;
    }

    public void setTimestampAlignmentEnabled(Boolean timestampAlignmentEnabled) {
        this.timestampAlignmentEnabled = timestampAlignmentEnabled;
    }

    public void setSpecialWordFilter(String specialWordFilter) {
        this.specialWordFilter = specialWordFilter;
    }

    public void setAudioEventDetectionEnabled(Boolean audioEventDetectionEnabled) {
        this.audioEventDetectionEnabled = audioEventDetectionEnabled;
    }

    @Override
    public String toString() {
        return "TranscriptionParam(fileUrls=" + this.getFileUrls() + ", phraseId=" + this.getPhraseId() + ", channelId=" + this.getChannelId() + ", diarizationEnabled=" + this.getDiarizationEnabled() + ", speakerCount=" + this.getSpeakerCount() + ", disfluencyRemovalEnabled=" + this.getDisfluencyRemovalEnabled() + ", timestampAlignmentEnabled=" + this.getTimestampAlignmentEnabled() + ", specialWordFilter=" + this.getSpecialWordFilter() + ", audioEventDetectionEnabled=" + this.getAudioEventDetectionEnabled() + ")";
    }

    private static final class TranscriptionParamBuilderImpl
    extends TranscriptionParamBuilder<TranscriptionParam, TranscriptionParamBuilderImpl> {
        private TranscriptionParamBuilderImpl() {
        }

        @Override
        protected TranscriptionParamBuilderImpl self() {
            return this;
        }

        @Override
        public TranscriptionParam build() {
            return new TranscriptionParam(this);
        }
    }

    public static abstract class TranscriptionParamBuilder<C extends TranscriptionParam, B extends TranscriptionParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private List<String> fileUrls;
        private String phraseId;
        private boolean channelId$set;
        private List<Integer> channelId$value;
        private Boolean diarizationEnabled;
        private Integer speakerCount;
        private Boolean disfluencyRemovalEnabled;
        private Boolean timestampAlignmentEnabled;
        private String specialWordFilter;
        private Boolean audioEventDetectionEnabled;

        public B fileUrls(@NonNull List<String> fileUrls) {
            if (fileUrls == null) {
                throw new NullPointerException("fileUrls is marked non-null but is null");
            }
            this.fileUrls = fileUrls;
            return (B)this.self();
        }

        public B phraseId(String phraseId) {
            this.phraseId = phraseId;
            return (B)this.self();
        }

        public B channelId(List<Integer> channelId) {
            this.channelId$value = channelId;
            this.channelId$set = true;
            return (B)this.self();
        }

        public B diarizationEnabled(Boolean diarizationEnabled) {
            this.diarizationEnabled = diarizationEnabled;
            return (B)this.self();
        }

        public B speakerCount(Integer speakerCount) {
            this.speakerCount = speakerCount;
            return (B)this.self();
        }

        public B disfluencyRemovalEnabled(Boolean disfluencyRemovalEnabled) {
            this.disfluencyRemovalEnabled = disfluencyRemovalEnabled;
            return (B)this.self();
        }

        public B timestampAlignmentEnabled(Boolean timestampAlignmentEnabled) {
            this.timestampAlignmentEnabled = timestampAlignmentEnabled;
            return (B)this.self();
        }

        public B specialWordFilter(String specialWordFilter) {
            this.specialWordFilter = specialWordFilter;
            return (B)this.self();
        }

        public B audioEventDetectionEnabled(Boolean audioEventDetectionEnabled) {
            this.audioEventDetectionEnabled = audioEventDetectionEnabled;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TranscriptionParam.TranscriptionParamBuilder(super=" + super.toString() + ", fileUrls=" + this.fileUrls + ", phraseId=" + this.phraseId + ", channelId$value=" + this.channelId$value + ", diarizationEnabled=" + this.diarizationEnabled + ", speakerCount=" + this.speakerCount + ", disfluencyRemovalEnabled=" + this.disfluencyRemovalEnabled + ", timestampAlignmentEnabled=" + this.timestampAlignmentEnabled + ", specialWordFilter=" + this.specialWordFilter + ", audioEventDetectionEnabled=" + this.audioEventDetectionEnabled + ")";
        }
    }
}

