/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.conversation;

import com.alibaba.dashscope.aigc.generation.GenerationParamBase;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationParam
extends GenerationParamBase {
    private static final Logger log = LoggerFactory.getLogger(ConversationParam.class);
    private List<Message> messages;
    private Integer maxLength;
    private Double topP;
    private Integer topK;
    private Boolean enableSearch;
    private Integer seed;
    @SerializedName(value="result_format")
    private String resultFormat;

    @Override
    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        JsonArray requestMessages = new JsonArray();
        if (this.getMessages() != null && !this.getMessages().isEmpty()) {
            requestMessages.addAll(JsonUtils.toJsonArray(this.getMessages()));
            if (this.getPrompt() != null) {
                Object msg = ((Message.MessageBuilder)((Message.MessageBuilder)Message.builder().role(Role.USER.getValue())).content(this.getPrompt())).build();
                requestMessages.add(JsonUtils.toJsonElement(msg));
            }
            jsonObject.add("messages", (JsonElement)requestMessages);
        } else if (this.getHistory() != null && !this.getHistory().isEmpty()) {
            JsonArray ar = JsonUtils.toJsonElement(this.getHistory()).getAsJsonArray();
            jsonObject.add("history", (JsonElement)ar);
            if (this.getPrompt() != null) {
                jsonObject.addProperty("prompt", this.getPrompt());
            }
        } else if (this.getPrompt() != null) {
            jsonObject.addProperty("prompt", this.getPrompt());
        }
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.maxLength != null) {
            params.put("max_length", this.maxLength);
        }
        if (this.topP != null) {
            params.put("top_p", this.topP);
        }
        if (this.topK != null) {
            params.put("top_k", this.topK);
        }
        params.put("enable_search", this.enableSearch);
        if (ResultFormat.MESSAGE.equals(this.getResultFormat())) {
            params.put("result_format", this.getResultFormat());
        }
        if (this.seed != null) {
            params.put("seed", this.seed);
        }
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.getModel().equals("qwen-plus-v1")) {
            log.warn("Model: {} is deprecated, use: {} instead!", (Object)this.getModel(), (Object)"qwen-plus");
        }
        if (this.getModel().equals("qwen-v1")) {
            log.warn("Model: {} is deprecated, use: {} instead!", (Object)this.getModel(), (Object)"qwen-turbo");
        }
        if (this.getPrompt() == null && (this.getHistory() == null || this.getHistory().isEmpty()) && (this.getMessages() == null || this.getMessages().isEmpty())) {
            throw new InputRequiredException("history and prompt must not all null");
        }
    }

    private static Boolean $default$enableSearch() {
        return false;
    }

    private static String $default$resultFormat() {
        return ResultFormat.TEXT;
    }

    protected ConversationParam(ConversationParamBuilder<?, ?> b) {
        super((GenerationParamBase.GenerationParamBaseBuilder<?, ?>)b);
        this.messages = ((ConversationParamBuilder)b).messages;
        this.maxLength = ((ConversationParamBuilder)b).maxLength;
        this.topP = ((ConversationParamBuilder)b).topP;
        this.topK = ((ConversationParamBuilder)b).topK;
        this.enableSearch = ((ConversationParamBuilder)b).enableSearch$set ? ((ConversationParamBuilder)b).enableSearch$value : ConversationParam.$default$enableSearch();
        this.seed = ((ConversationParamBuilder)b).seed;
        this.resultFormat = ((ConversationParamBuilder)b).resultFormat$set ? ((ConversationParamBuilder)b).resultFormat$value : ConversationParam.$default$resultFormat();
    }

    public static ConversationParamBuilder<?, ?> builder() {
        return new ConversationParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationParam)) {
            return false;
        }
        ConversationParam other = (ConversationParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Boolean this$enableSearch = this.getEnableSearch();
        Boolean other$enableSearch = other.getEnableSearch();
        if (this$enableSearch == null ? other$enableSearch != null : !((Object)this$enableSearch).equals(other$enableSearch)) {
            return false;
        }
        Integer this$seed = this.getSeed();
        Integer other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        String this$resultFormat = this.getResultFormat();
        String other$resultFormat = other.getResultFormat();
        return !(this$resultFormat == null ? other$resultFormat != null : !this$resultFormat.equals(other$resultFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConversationParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Boolean $enableSearch = this.getEnableSearch();
        result = result * 59 + ($enableSearch == null ? 43 : ((Object)$enableSearch).hashCode());
        Integer $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        String $resultFormat = this.getResultFormat();
        result = result * 59 + ($resultFormat == null ? 43 : $resultFormat.hashCode());
        return result;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Boolean getEnableSearch() {
        return this.enableSearch;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public String getResultFormat() {
        return this.resultFormat;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public void setEnableSearch(Boolean enableSearch) {
        this.enableSearch = enableSearch;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    public void setResultFormat(String resultFormat) {
        this.resultFormat = resultFormat;
    }

    @Override
    public String toString() {
        return "ConversationParam(messages=" + this.getMessages() + ", maxLength=" + this.getMaxLength() + ", topP=" + this.getTopP() + ", topK=" + this.getTopK() + ", enableSearch=" + this.getEnableSearch() + ", seed=" + this.getSeed() + ", resultFormat=" + this.getResultFormat() + ")";
    }

    private static final class ConversationParamBuilderImpl
    extends ConversationParamBuilder<ConversationParam, ConversationParamBuilderImpl> {
        private ConversationParamBuilderImpl() {
        }

        @Override
        protected ConversationParamBuilderImpl self() {
            return this;
        }

        @Override
        public ConversationParam build() {
            return new ConversationParam(this);
        }
    }

    public static abstract class ConversationParamBuilder<C extends ConversationParam, B extends ConversationParamBuilder<C, B>>
    extends GenerationParamBase.GenerationParamBaseBuilder<C, B> {
        private List<Message> messages;
        private Integer maxLength;
        private Double topP;
        private Integer topK;
        private boolean enableSearch$set;
        private Boolean enableSearch$value;
        private Integer seed;
        private boolean resultFormat$set;
        private String resultFormat$value;

        public B messages(List<Message> messages) {
            this.messages = messages;
            return (B)this.self();
        }

        public B maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        public B topP(Double topP) {
            this.topP = topP;
            return (B)this.self();
        }

        public B topK(Integer topK) {
            this.topK = topK;
            return (B)this.self();
        }

        public B enableSearch(Boolean enableSearch) {
            this.enableSearch$value = enableSearch;
            this.enableSearch$set = true;
            return (B)this.self();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return (B)this.self();
        }

        public B resultFormat(String resultFormat) {
            this.resultFormat$value = resultFormat;
            this.resultFormat$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ConversationParam.ConversationParamBuilder(super=" + super.toString() + ", messages=" + this.messages + ", maxLength=" + this.maxLength + ", topP=" + this.topP + ", topK=" + this.topK + ", enableSearch$value=" + this.enableSearch$value + ", seed=" + this.seed + ", resultFormat$value=" + this.resultFormat$value + ")";
        }
    }

    public static class ResultFormat {
        public static String TEXT = "text";
        public static String MESSAGE = "message";
    }
}

