/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.asr.transcription;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class TranscriptionParam
extends HalfDuplexServiceParam {
    @NonNull
    private List<String> fileUrls;
    private List<Integer> channelId;
    private Boolean diarizationEnabled;
    private Integer speakerCount;

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.addProperty("model", this.getModel());
        JsonArray jsonFileUrls = new JsonArray();
        for (String string : this.fileUrls) {
            jsonFileUrls.add(string);
        }
        JsonArray jsonChannelId = new JsonArray();
        if (this.channelId == null) {
            this.channelId = Collections.singletonList(0);
        }
        for (Integer id : this.channelId) {
            jsonChannelId.add((Number)id);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("file_urls", (JsonElement)jsonFileUrls);
        body.add("input", (JsonElement)jsonObject);
        JsonObject jsonParameters = new JsonObject();
        jsonParameters.add("channel_id", (JsonElement)jsonChannelId);
        if (this.diarizationEnabled != null) {
            jsonParameters.addProperty("diarization_enabled", this.diarizationEnabled);
        }
        if (this.speakerCount != null) {
            jsonParameters.addProperty("speaker_count", (Number)this.speakerCount);
        }
        body.add("parameters", (JsonElement)jsonParameters);
        return body;
    }

    @Override
    public Object getInput() {
        JsonArray jsonFileUrls = new JsonArray();
        for (String fileUrl : this.fileUrls) {
            jsonFileUrls.add(fileUrl);
        }
        JsonObject jsonInput = new JsonObject();
        jsonInput.add("file_urls", (JsonElement)jsonFileUrls);
        return jsonInput;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    private static List<Integer> $default$channelId() {
        return Collections.singletonList(0);
    }

    protected TranscriptionParam(TranscriptionParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.fileUrls = ((TranscriptionParamBuilder)b).fileUrls;
        if (this.fileUrls == null) {
            throw new NullPointerException("fileUrls is marked non-null but is null");
        }
        this.channelId = ((TranscriptionParamBuilder)b).channelId$set ? ((TranscriptionParamBuilder)b).channelId$value : TranscriptionParam.$default$channelId();
        this.diarizationEnabled = ((TranscriptionParamBuilder)b).diarizationEnabled;
        this.speakerCount = ((TranscriptionParamBuilder)b).speakerCount;
    }

    public static TranscriptionParamBuilder<?, ?> builder() {
        return new TranscriptionParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranscriptionParam)) {
            return false;
        }
        TranscriptionParam other = (TranscriptionParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$diarizationEnabled = this.getDiarizationEnabled();
        Boolean other$diarizationEnabled = other.getDiarizationEnabled();
        if (this$diarizationEnabled == null ? other$diarizationEnabled != null : !((Object)this$diarizationEnabled).equals(other$diarizationEnabled)) {
            return false;
        }
        Integer this$speakerCount = this.getSpeakerCount();
        Integer other$speakerCount = other.getSpeakerCount();
        if (this$speakerCount == null ? other$speakerCount != null : !((Object)this$speakerCount).equals(other$speakerCount)) {
            return false;
        }
        List<String> this$fileUrls = this.getFileUrls();
        List<String> other$fileUrls = other.getFileUrls();
        if (this$fileUrls == null ? other$fileUrls != null : !((Object)this$fileUrls).equals(other$fileUrls)) {
            return false;
        }
        List<Integer> this$channelId = this.getChannelId();
        List<Integer> other$channelId = other.getChannelId();
        return !(this$channelId == null ? other$channelId != null : !((Object)this$channelId).equals(other$channelId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TranscriptionParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $diarizationEnabled = this.getDiarizationEnabled();
        result = result * 59 + ($diarizationEnabled == null ? 43 : ((Object)$diarizationEnabled).hashCode());
        Integer $speakerCount = this.getSpeakerCount();
        result = result * 59 + ($speakerCount == null ? 43 : ((Object)$speakerCount).hashCode());
        List<String> $fileUrls = this.getFileUrls();
        result = result * 59 + ($fileUrls == null ? 43 : ((Object)$fileUrls).hashCode());
        List<Integer> $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : ((Object)$channelId).hashCode());
        return result;
    }

    @NonNull
    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    public List<Integer> getChannelId() {
        return this.channelId;
    }

    public Boolean getDiarizationEnabled() {
        return this.diarizationEnabled;
    }

    public Integer getSpeakerCount() {
        return this.speakerCount;
    }

    public void setFileUrls(@NonNull List<String> fileUrls) {
        if (fileUrls == null) {
            throw new NullPointerException("fileUrls is marked non-null but is null");
        }
        this.fileUrls = fileUrls;
    }

    public void setChannelId(List<Integer> channelId) {
        this.channelId = channelId;
    }

    public void setDiarizationEnabled(Boolean diarizationEnabled) {
        this.diarizationEnabled = diarizationEnabled;
    }

    public void setSpeakerCount(Integer speakerCount) {
        this.speakerCount = speakerCount;
    }

    @Override
    public String toString() {
        return "TranscriptionParam(fileUrls=" + this.getFileUrls() + ", channelId=" + this.getChannelId() + ", diarizationEnabled=" + this.getDiarizationEnabled() + ", speakerCount=" + this.getSpeakerCount() + ")";
    }

    private static final class TranscriptionParamBuilderImpl
    extends TranscriptionParamBuilder<TranscriptionParam, TranscriptionParamBuilderImpl> {
        private TranscriptionParamBuilderImpl() {
        }

        @Override
        protected TranscriptionParamBuilderImpl self() {
            return this;
        }

        @Override
        public TranscriptionParam build() {
            return new TranscriptionParam(this);
        }
    }

    public static abstract class TranscriptionParamBuilder<C extends TranscriptionParam, B extends TranscriptionParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private List<String> fileUrls;
        private boolean channelId$set;
        private List<Integer> channelId$value;
        private Boolean diarizationEnabled;
        private Integer speakerCount;

        public B fileUrls(@NonNull List<String> fileUrls) {
            if (fileUrls == null) {
                throw new NullPointerException("fileUrls is marked non-null but is null");
            }
            this.fileUrls = fileUrls;
            return (B)this.self();
        }

        public B channelId(List<Integer> channelId) {
            this.channelId$value = channelId;
            this.channelId$set = true;
            return (B)this.self();
        }

        public B diarizationEnabled(Boolean diarizationEnabled) {
            this.diarizationEnabled = diarizationEnabled;
            return (B)this.self();
        }

        public B speakerCount(Integer speakerCount) {
            this.speakerCount = speakerCount;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TranscriptionParam.TranscriptionParamBuilder(super=" + super.toString() + ", fileUrls=" + this.fileUrls + ", channelId$value=" + this.channelId$value + ", diarizationEnabled=" + this.diarizationEnabled + ", speakerCount=" + this.speakerCount + ")";
        }
    }
}

