/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.tts;

import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.audio.tts.SpeechSynthesisParam;
import com.alibaba.dashscope.audio.tts.SpeechSynthesisResult;
import com.alibaba.dashscope.audio.tts.timestamp.Sentence;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Status;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ClientOptions;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.google.common.collect.Lists;
import io.reactivex.Flowable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpeechSynthesizer {
    private static final Logger log = LoggerFactory.getLogger(SpeechSynthesizer.class);
    private final List<Sentence> timestamps = Lists.newCopyOnWriteArrayList();
    private ByteBuffer audioData;
    private ApiServiceOption serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.WEBSOCKET)).streamingMode(StreamingMode.OUT)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AUDIO.getValue())).task(Task.TEXT_TO_SPEECH.getValue())).function(Function.SPEECH_SYNTHESIZER.getValue())).build();
    private final SynchronizeHalfDuplexApi<SpeechSynthesisParam> syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(Protocol.WEBSOCKET.getValue())).build(), this.serviceOption);

    public void call(SpeechSynthesisParam param, final ResultCallback<SpeechSynthesisResult> callback) {
        this.timestamps.clear();
        this.audioData = null;
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        final WritableByteChannel channel = Channels.newChannel(outputStream);
        try {
            class SynthesisCallback
            extends ResultCallback<DashScopeResult> {
                private Sentence lastSentence = null;

                SynthesisCallback() {
                }

                @Override
                public void onOpen(Status status) {
                    callback.onOpen(status);
                }

                @Override
                public void onEvent(DashScopeResult message) {
                    SpeechSynthesisResult result = SpeechSynthesisResult.fromDashScopeResult(message);
                    try {
                        if (result.getTimestamp() != null) {
                            Sentence sentence = result.getTimestamp();
                            if (this.lastSentence == null) {
                                this.lastSentence = sentence;
                                SpeechSynthesizer.this.timestamps.add(sentence);
                            } else if (!this.lastSentence.equals(sentence)) {
                                this.lastSentence = sentence;
                                SpeechSynthesizer.this.timestamps.add(sentence);
                            }
                        }
                        if (result.getAudioFrame() != null) {
                            try {
                                channel.write(result.getAudioFrame());
                            }
                            catch (IOException e) {
                                log.error("Failed to write audio: {}", (Object)result.getAudioFrame(), (Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to parse response: {}", (Object)message, (Object)e);
                        callback.onError(e);
                    }
                    callback.onEvent(result);
                }

                @Override
                public void onComplete() {
                    try {
                        SpeechSynthesizer.this.audioData = ByteBuffer.wrap(outputStream.toByteArray());
                        channel.close();
                        outputStream.close();
                    }
                    catch (IOException e) {
                        log.error("Failed to close channel: {}", (Object)channel, (Object)e);
                    }
                    callback.onComplete();
                }

                @Override
                public void onError(Exception e) {
                    callback.onError(e);
                }
            }
            this.syncApi.streamCall(param, new SynthesisCallback());
        }
        catch (NoApiKeyException e) {
            throw new ApiException(e);
        }
    }

    public Flowable<SpeechSynthesisResult> streamCall(SpeechSynthesisParam param) {
        this.audioData = null;
        this.timestamps.clear();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(outputStream);
        AtomicReference lastSentenceRef = new AtomicReference();
        try {
            return this.syncApi.streamCall(param).map(message -> {
                SpeechSynthesisResult result = SpeechSynthesisResult.fromDashScopeResult(message);
                if (result.getTimestamp() != null) {
                    Sentence sentence = result.getTimestamp();
                    if (lastSentenceRef.get() == null) {
                        lastSentenceRef.set(sentence);
                        this.timestamps.add(sentence);
                    } else if (!((Sentence)lastSentenceRef.get()).equals(sentence)) {
                        lastSentenceRef.set(sentence);
                        this.timestamps.add(sentence);
                    }
                    this.timestamps.add(result.getTimestamp());
                }
                if (result.getAudioFrame() != null) {
                    try {
                        channel.write(result.getAudioFrame());
                    }
                    catch (IOException e) {
                        log.error("Failed to write audio: {}", (Object)result.getAudioFrame(), (Object)e);
                    }
                }
                return result;
            }).doOnComplete(() -> {
                try {
                    this.audioData = ByteBuffer.wrap(outputStream.toByteArray());
                    channel.close();
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("Failed to close channel: {}", (Object)channel, (Object)e);
                }
            }).doOnError(e -> {
                try {
                    channel.close();
                    outputStream.close();
                    this.timestamps.clear();
                    this.audioData = null;
                }
                catch (IOException ex) {
                    log.error("Failed to close channel: {}", (Object)channel, (Object)ex);
                }
            });
        }
        catch (NoApiKeyException e2) {
            throw new ApiException(e2);
        }
    }

    public ByteBuffer call(SpeechSynthesisParam param) {
        AtomicReference<Object> finalError = new AtomicReference<Object>(null);
        Flowable<SpeechSynthesisResult> flowable = this.streamCall(param);
        flowable.doOnError(finalError::set).blockingLast();
        if (finalError.get() != null) {
            throw new ApiException(finalError.get());
        }
        return this.audioData;
    }

    public List<Sentence> getTimestamps() {
        return this.timestamps;
    }

    public ByteBuffer getAudioData() {
        return this.audioData;
    }
}

