/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.utils.ApiKey;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public final class DashScopeHeaders {
    private static String userAgent() {
        String userAgent = String.format("dashscope/%s; java/%s; platform/%s; processor/%s", "2.5.0", System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"));
        return userAgent;
    }

    public static Map<String, String> buildWebSocketHeaders(String apiKey, boolean isSecurityCheck) throws NoApiKeyException {
        HashMap headers = Maps.newHashMap();
        headers.put("Authorization", "bearer " + ApiKey.getApiKey(apiKey));
        headers.put("user-agent", DashScopeHeaders.userAgent());
        if (isSecurityCheck) {
            headers.put("X-DashScope-DataInspection", "enable");
        }
        return headers;
    }

    public static Map<String, String> buildHttpHeaders(String apiKey, Boolean isSecurityCheck, Protocol protocol, Boolean isSSE, Boolean isAsyncTask) throws NoApiKeyException {
        HashMap headers = Maps.newHashMap();
        headers.put("Authorization", "Bearer " + ApiKey.getApiKey(apiKey));
        headers.put("user-agent", DashScopeHeaders.userAgent());
        if (isSecurityCheck.booleanValue()) {
            headers.put("X-DashScope-DataInspection", "enable");
        }
        if (protocol == Protocol.HTTP) {
            if (isAsyncTask.booleanValue()) {
                headers.put("X-DashScope-Async", "enable");
            }
            headers.put("Content-Type", "application/json");
            if (isSSE.booleanValue()) {
                headers.put("Cache-Control", "no-cache");
                headers.put("Accept", "text/event-stream");
                headers.put("X-Accel-Buffering", "no");
                headers.put("X-DashScope-SSE", "enable");
            } else {
                headers.put("Accept", "application/json; charset=utf-8");
            }
        }
        return headers;
    }
}

