/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.common;

import com.alibaba.dashscope.common.Result;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.protocol.NetworkResponse;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;

public class DashScopeResult
extends Result {
    private Object output;

    public Boolean isBinaryOutput() {
        return this.output instanceof ByteBuffer;
    }

    @Override
    public <T extends Result> T fromResponse(Protocol protocol, NetworkResponse response) throws ApiException {
        if (protocol == Protocol.WEBSOCKET) {
            if (response.getBinary() == null) {
                JsonObject headers;
                JsonObject jsonObject = JsonUtils.parse(response.getMessage());
                if (jsonObject.has("header") && (headers = jsonObject.get("header").getAsJsonObject()).has("task_id")) {
                    this.setRequestId(headers.get("task_id").getAsString());
                }
                if (jsonObject.has("payload")) {
                    JsonObject payload = jsonObject.getAsJsonObject("payload");
                    if (payload.has("output")) {
                        Object object = this.output = payload.get("output").isJsonNull() ? null : payload.get("output");
                    }
                    if (payload.has("usage")) {
                        this.setUsage(payload.get("usage").isJsonNull() ? null : payload.get("usage"));
                    }
                }
            } else {
                this.output = response.getBinary();
            }
        } else {
            JsonObject jsonObject = JsonUtils.parse(response.getMessage());
            if (jsonObject.has("output")) {
                Object object = this.output = jsonObject.get("output").isJsonNull() ? null : jsonObject.get("output").getAsJsonObject();
            }
            if (jsonObject.has("usage")) {
                this.setUsage((JsonElement)(jsonObject.get("usage").isJsonNull() ? null : jsonObject.get("usage").getAsJsonObject()));
            }
            if (jsonObject.has("request_id")) {
                this.setRequestId(jsonObject.get("request_id").getAsString());
            }
            if (jsonObject.has("data")) {
                if (jsonObject.has("request_id")) {
                    jsonObject.remove("request_id");
                }
                this.output = jsonObject;
            }
        }
        return (T)this;
    }

    public Object getOutput() {
        return this.output;
    }

    public void setOutput(Object output) {
        this.output = output;
    }

    @Override
    public String toString() {
        return "DashScopeResult(output=" + this.getOutput() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashScopeResult)) {
            return false;
        }
        DashScopeResult other = (DashScopeResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$output = this.getOutput();
        Object other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !this$output.equals(other$output));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashScopeResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        return result;
    }
}

