/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm.internal;

import com.alibaba.dcm.internal.IpParserUtil;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import sun.net.InetAddressCachePolicy;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class InetAddressCacheUtilCommons {
    public static final long NEVER_EXPIRATION = Long.MAX_VALUE;
    private static volatile Field cachePolicyFiledOfInetAddressCachePolicy = null;
    private static volatile Field negativeCachePolicyFiledOfInetAddressCachePolicy = null;
    private static volatile Field setFiledOfInetAddressCachePolicy = null;
    private static volatile Field negativeSetOfInetAddressCachePolicy = null;

    static InetAddress[] toInetAddressArray(String host, String[] ips) throws UnknownHostException {
        InetAddress[] addresses = new InetAddress[ips.length];
        for (int i = 0; i < addresses.length; ++i) {
            addresses[i] = InetAddress.getByAddress(host, IpParserUtil.ip2ByteArray(ips[i]));
        }
        return addresses;
    }

    static String[] getIpFromInetAddress(@Nullable InetAddress[] inetAddresses) {
        if (inetAddresses == null) {
            return new String[0];
        }
        String[] ips = new String[inetAddresses.length];
        for (int i = 0; i < inetAddresses.length; ++i) {
            ips[i] = inetAddresses[i].getHostAddress();
        }
        return ips;
    }

    public static void setDnsCachePolicy(int cacheSeconds) throws NoSuchFieldException, IllegalAccessException {
        InetAddressCacheUtilCommons.setCachePolicy0(false, cacheSeconds);
    }

    public static int getDnsCachePolicy() {
        return InetAddressCachePolicy.get();
    }

    public static void setDnsNegativeCachePolicy(int negativeCacheSeconds) throws NoSuchFieldException, IllegalAccessException {
        InetAddressCacheUtilCommons.setCachePolicy0(true, negativeCacheSeconds);
    }

    public static int getDnsNegativeCachePolicy() {
        return InetAddressCachePolicy.getNegative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCachePolicy0(boolean isNegative, int seconds) throws NoSuchFieldException, IllegalAccessException {
        if (seconds < 0) {
            seconds = -1;
        }
        InetAddressCacheUtilCommons.initFieldsOfInetAddressCachePolicy();
        Class<InetAddressCachePolicy> clazz = InetAddressCachePolicy.class;
        synchronized (InetAddressCachePolicy.class) {
            if (isNegative) {
                negativeCachePolicyFiledOfInetAddressCachePolicy.setInt(null, seconds);
                negativeSetOfInetAddressCachePolicy.setBoolean(null, true);
            } else {
                cachePolicyFiledOfInetAddressCachePolicy.setInt(null, seconds);
                setFiledOfInetAddressCachePolicy.setBoolean(null, true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFieldsOfInetAddressCachePolicy() throws NoSuchFieldException {
        if (negativeSetOfInetAddressCachePolicy != null) {
            return;
        }
        Class<InetAddressCachePolicy> clazz = InetAddressCachePolicy.class;
        Class<InetAddressCacheUtilCommons> clazz2 = InetAddressCacheUtilCommons.class;
        synchronized (InetAddressCacheUtilCommons.class) {
            if (negativeSetOfInetAddressCachePolicy != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Field f = clazz.getDeclaredField("cachePolicy");
            f.setAccessible(true);
            cachePolicyFiledOfInetAddressCachePolicy = f;
            f = clazz.getDeclaredField("negativeCachePolicy");
            f.setAccessible(true);
            negativeCachePolicyFiledOfInetAddressCachePolicy = f;
            try {
                f = clazz.getDeclaredField("propertySet");
            }
            catch (NoSuchFieldException e) {
                f = clazz.getDeclaredField("set");
            }
            f.setAccessible(true);
            setFiledOfInetAddressCachePolicy = f;
            try {
                f = clazz.getDeclaredField("propertyNegativeSet");
            }
            catch (NoSuchFieldException e) {
                f = clazz.getDeclaredField("negativeSet");
            }
            f.setAccessible(true);
            negativeSetOfInetAddressCachePolicy = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private InetAddressCacheUtilCommons() {
    }
}

