/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm.internal;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.internal.InetAddressCacheUtilCommons;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class InetAddressCacheUtilForJava8Minus {
    private static volatile Constructor<?> constructorOfInetAddress$CacheEntry = null;
    private static volatile Field cacheMapFieldOfInetAddress$Cache = null;
    private static volatile Object[] ADDRESS_CACHE_AND_NEGATIVE_CACHE = null;
    private static volatile Field expirationFieldOfInetAddress$CacheEntry = null;
    private static volatile Field addressesFieldOfInetAddress$CacheEntry = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInetAddressCache(String host, String[] ips, long expireMillis) throws UnknownHostException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException {
        host = host.toLowerCase();
        long expiration = expireMillis == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + expireMillis;
        Object entry = InetAddressCacheUtilForJava8Minus.newCacheEntry(host, ips, expiration);
        Object object = InetAddressCacheUtilForJava8Minus.getAddressCacheOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtilForJava8Minus.getCache().put(host, entry);
            InetAddressCacheUtilForJava8Minus.getNegativeCache().remove(host);
        }
    }

    private static Object newCacheEntry(String host, String[] ips, long expiration) throws UnknownHostException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return InetAddressCacheUtilForJava8Minus.getConstructorOfInetAddress$CacheEntry().newInstance(InetAddressCacheUtilCommons.toInetAddressArray(host, ips), expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Constructor<?> getConstructorOfInetAddress$CacheEntry() throws ClassNotFoundException {
        if (constructorOfInetAddress$CacheEntry != null) {
            return constructorOfInetAddress$CacheEntry;
        }
        Class<InetAddressCacheUtilCommons> clazz = InetAddressCacheUtilCommons.class;
        synchronized (InetAddressCacheUtilCommons.class) {
            if (constructorOfInetAddress$CacheEntry != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return constructorOfInetAddress$CacheEntry;
            }
            String className = "java.net.InetAddress$CacheEntry";
            Class<?> clazz2 = Class.forName("java.net.InetAddress$CacheEntry");
            Constructor<?> constructor = clazz2.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            constructorOfInetAddress$CacheEntry = constructor;
            // ** MonitorExit[var0] (shouldn't be in output)
            return constructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        host = host.toLowerCase();
        Object object = InetAddressCacheUtilForJava8Minus.getAddressCacheOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtilForJava8Minus.getCache().remove(host);
            InetAddressCacheUtilForJava8Minus.getNegativeCache().remove(host);
        }
    }

    @GuardedBy(value="getAddressCacheOfInetAddress()")
    private static Map<String, Object> getCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        return InetAddressCacheUtilForJava8Minus.getCacheOfInetAddress$Cache0(InetAddressCacheUtilForJava8Minus.getAddressCacheOfInetAddress());
    }

    @GuardedBy(value="getAddressCacheOfInetAddress()")
    private static Map<String, Object> getNegativeCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        return InetAddressCacheUtilForJava8Minus.getCacheOfInetAddress$Cache0(InetAddressCacheUtilForJava8Minus.getNegativeCacheOfInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Object> getCacheOfInetAddress$Cache0(Object inetAddressCache) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        if (cacheMapFieldOfInetAddress$Cache != null) return (Map)cacheMapFieldOfInetAddress$Cache.get(inetAddressCache);
        Class<InetAddressCacheUtilForJava8Minus> clazz = InetAddressCacheUtilForJava8Minus.class;
        synchronized (InetAddressCacheUtilForJava8Minus.class) {
            if (cacheMapFieldOfInetAddress$Cache != null) return (Map)cacheMapFieldOfInetAddress$Cache.get(inetAddressCache);
            Class<?> clazz2 = Class.forName("java.net.InetAddress$Cache");
            Field f = clazz2.getDeclaredField("cache");
            f.setAccessible(true);
            cacheMapFieldOfInetAddress$Cache = f;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Map)cacheMapFieldOfInetAddress$Cache.get(inetAddressCache);
        }
    }

    private static Object getAddressCacheOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtilForJava8Minus.getAddressCacheAndNegativeCacheOfInetAddress0()[0];
    }

    private static Object getNegativeCacheOfInetAddress() throws NoSuchFieldException, IllegalAccessException {
        return InetAddressCacheUtilForJava8Minus.getAddressCacheAndNegativeCacheOfInetAddress0()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] getAddressCacheAndNegativeCacheOfInetAddress0() throws NoSuchFieldException, IllegalAccessException {
        if (ADDRESS_CACHE_AND_NEGATIVE_CACHE != null) {
            return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
        }
        Class<InetAddressCacheUtilForJava8Minus> clazz = InetAddressCacheUtilForJava8Minus.class;
        synchronized (InetAddressCacheUtilForJava8Minus.class) {
            if (ADDRESS_CACHE_AND_NEGATIVE_CACHE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
            }
            Field cacheField = InetAddress.class.getDeclaredField("addressCache");
            cacheField.setAccessible(true);
            Field negativeCacheField = InetAddress.class.getDeclaredField("negativeCache");
            negativeCacheField.setAccessible(true);
            ADDRESS_CACHE_AND_NEGATIVE_CACHE = new Object[]{cacheField.get(InetAddress.class), negativeCacheField.get(InetAddress.class)};
            // ** MonitorExit[var0] (shouldn't be in output)
            return ADDRESS_CACHE_AND_NEGATIVE_CACHE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DnsCacheEntry getInetAddressCache(String host) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Object cacheEntry;
        host = host.toLowerCase();
        Object object = InetAddressCacheUtilForJava8Minus.getAddressCacheOfInetAddress();
        synchronized (object) {
            cacheEntry = InetAddressCacheUtilForJava8Minus.getCache().get(host);
        }
        if (null == cacheEntry) {
            return null;
        }
        DnsCacheEntry dnsCacheEntry = InetAddressCacheUtilForJava8Minus.inetAddress$CacheEntry2DnsCacheEntry(host, cacheEntry);
        if (InetAddressCacheUtilForJava8Minus.isDnsCacheEntryExpired(dnsCacheEntry.getHost())) {
            return null;
        }
        return dnsCacheEntry;
    }

    private static boolean isDnsCacheEntryExpired(@Nullable String host) {
        return null == host || "0.0.0.0".equals(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DnsCache listInetAddressCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        HashMap<String, Object> negativeCache;
        HashMap<String, Object> cache;
        Object object = InetAddressCacheUtilForJava8Minus.getAddressCacheOfInetAddress();
        synchronized (object) {
            cache = new HashMap<String, Object>(InetAddressCacheUtilForJava8Minus.getCache());
            negativeCache = new HashMap<String, Object>(InetAddressCacheUtilForJava8Minus.getNegativeCache());
        }
        return new DnsCache(InetAddressCacheUtilForJava8Minus.convert(cache), InetAddressCacheUtilForJava8Minus.convert(negativeCache));
    }

    private static List<DnsCacheEntry> convert(Map<String, Object> cache) throws IllegalAccessException, ClassNotFoundException {
        ArrayList<DnsCacheEntry> ret = new ArrayList<DnsCacheEntry>();
        for (Map.Entry<String, Object> entry : cache.entrySet()) {
            String host = entry.getKey();
            if (InetAddressCacheUtilForJava8Minus.isDnsCacheEntryExpired(host)) continue;
            ret.add(InetAddressCacheUtilForJava8Minus.inetAddress$CacheEntry2DnsCacheEntry(host, entry.getValue()));
        }
        return ret;
    }

    private static DnsCacheEntry inetAddress$CacheEntry2DnsCacheEntry(String host, Object entry) throws IllegalAccessException, ClassNotFoundException {
        InetAddressCacheUtilForJava8Minus.initFieldsOfInetAddress$CacheEntry();
        long expiration = expirationFieldOfInetAddress$CacheEntry.getLong(entry);
        InetAddress[] addresses = (InetAddress[])addressesFieldOfInetAddress$CacheEntry.get(entry);
        String[] ips = InetAddressCacheUtilCommons.getIpFromInetAddress(addresses);
        return new DnsCacheEntry(host, ips, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFieldsOfInetAddress$CacheEntry() throws ClassNotFoundException {
        if (expirationFieldOfInetAddress$CacheEntry != null && addressesFieldOfInetAddress$CacheEntry != null) {
            return;
        }
        Class<?> cacheEntryClass = Class.forName("java.net.InetAddress$CacheEntry");
        Class<InetAddressCacheUtilForJava8Minus> clazz = InetAddressCacheUtilForJava8Minus.class;
        synchronized (InetAddressCacheUtilForJava8Minus.class) {
            Field[] fields;
            if (expirationFieldOfInetAddress$CacheEntry != null && addressesFieldOfInetAddress$CacheEntry != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (Field field : fields = cacheEntryClass.getDeclaredFields()) {
                String name = field.getName();
                if (name.equals("expiration")) {
                    field.setAccessible(true);
                    expirationFieldOfInetAddress$CacheEntry = field;
                    continue;
                }
                if (name.startsWith("address")) {
                    field.setAccessible(true);
                    addressesFieldOfInetAddress$CacheEntry = field;
                    continue;
                }
                throw new IllegalStateException("JDK add new Field " + name + " for class InetAddress.CacheEntry, report issue for dns-cache-manipulator lib!");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInetAddressCache() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Object object = InetAddressCacheUtilForJava8Minus.getAddressCacheOfInetAddress();
        synchronized (object) {
            InetAddressCacheUtilForJava8Minus.getCache().clear();
            InetAddressCacheUtilForJava8Minus.getNegativeCache().clear();
        }
    }

    private InetAddressCacheUtilForJava8Minus() {
    }
}

