/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm;

import com.alibaba.dcm.DnsCache;
import com.alibaba.dcm.DnsCacheEntry;
import com.alibaba.dcm.DnsCacheManipulatorException;
import com.alibaba.dcm.internal.InetAddressCacheUtilCommons;
import com.alibaba.dcm.internal.InetAddressCacheUtilForNew;
import com.alibaba.dcm.internal.InetAddressCacheUtilForOld;
import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public final class DnsCacheManipulator {
    private static final Pattern COMMA_SEPARATOR = Pattern.compile("\\s*,\\s*");

    public static void setDnsCache(String host, String ... ips) {
        try {
            if (InetAddressCacheUtilCommons.isNewInetAddressImpl()) {
                InetAddressCacheUtilForNew.setInetAddressCache(host, ips, Long.MAX_VALUE);
            } else {
                InetAddressCacheUtilForOld.setInetAddressCache(host, ips, Long.MAX_VALUE);
            }
        }
        catch (Exception e) {
            String message = String.format("Fail to setDnsCache for host %s ip %s, cause: %s", host, Arrays.toString(ips), e);
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    public static void setDnsCache(long expireMillis, String host, String ... ips) {
        try {
            if (InetAddressCacheUtilCommons.isNewInetAddressImpl()) {
                InetAddressCacheUtilForNew.setInetAddressCache(host, ips, expireMillis);
            } else {
                InetAddressCacheUtilForOld.setInetAddressCache(host, ips, expireMillis);
            }
        }
        catch (Exception e) {
            String message = String.format("Fail to setDnsCache for host %s ip %s expireMillis %s, cause: %s", host, Arrays.toString(ips), expireMillis, e);
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    public static void setDnsCache(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String host = (String)entry.getKey();
            String ipList = (String)entry.getValue();
            if ((ipList = ipList.trim()).isEmpty()) continue;
            String[] ips = COMMA_SEPARATOR.split(ipList);
            DnsCacheManipulator.setDnsCache(host, ips);
        }
    }

    public static void loadDnsCacheConfig() {
        String DCM_CONFIG_FILE_NAME_KEY = "dcm.config.filename";
        String dcmConfigFileName = System.getProperty("dcm.config.filename", "dns-cache.properties");
        DnsCacheManipulator.loadDnsCacheConfig(dcmConfigFileName);
    }

    public static void loadDnsCacheConfig(String propertiesFileName) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFileName);
        if (inputStream == null) {
            inputStream = DnsCacheManipulator.class.getClassLoader().getResourceAsStream(propertiesFileName);
        }
        if (inputStream == null) {
            throw new DnsCacheManipulatorException("Fail to find " + propertiesFileName + " on classpath!");
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            DnsCacheManipulator.setDnsCache(properties);
        }
        catch (Exception e) {
            String message = String.format("Fail to loadDnsCacheConfig from %s, cause: %s", propertiesFileName, e);
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    @Nullable
    public static DnsCacheEntry getDnsCache(String host) {
        try {
            if (InetAddressCacheUtilCommons.isNewInetAddressImpl()) {
                return InetAddressCacheUtilForNew.getInetAddressCache(host);
            }
            return InetAddressCacheUtilForOld.getInetAddressCache(host);
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getDnsCache, cause: " + e, e);
        }
    }

    public static DnsCache getWholeDnsCache() {
        try {
            if (InetAddressCacheUtilCommons.isNewInetAddressImpl()) {
                return InetAddressCacheUtilForNew.listInetAddressCache();
            }
            return InetAddressCacheUtilForOld.listInetAddressCache();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getWholeDnsCache, cause: " + e, e);
        }
    }

    public static List<DnsCacheEntry> listDnsCache() {
        return DnsCacheManipulator.getWholeDnsCache().getCache();
    }

    @Deprecated
    public static List<DnsCacheEntry> getAllDnsCache() {
        return DnsCacheManipulator.listDnsCache();
    }

    public static List<DnsCacheEntry> listDnsNegativeCache() {
        return DnsCacheManipulator.getWholeDnsCache().getNegativeCache();
    }

    public static void removeDnsCache(String host) {
        try {
            if (InetAddressCacheUtilCommons.isNewInetAddressImpl()) {
                InetAddressCacheUtilForNew.removeInetAddressCache(host);
            } else {
                InetAddressCacheUtilForOld.removeInetAddressCache(host);
            }
        }
        catch (Exception e) {
            String message = String.format("Fail to removeDnsCache for host %s, cause: %s", host, e);
            throw new DnsCacheManipulatorException(message, e);
        }
    }

    public static void clearDnsCache() {
        try {
            if (InetAddressCacheUtilCommons.isNewInetAddressImpl()) {
                InetAddressCacheUtilForNew.clearInetAddressCache();
            } else {
                InetAddressCacheUtilForOld.clearInetAddressCache();
            }
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to clearDnsCache, cause: " + e, e);
        }
    }

    public static int getDnsCachePolicy() {
        try {
            return InetAddressCacheUtilCommons.getDnsCachePolicy();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getDnsCachePolicy, cause: " + e, e);
        }
    }

    public static void setDnsCachePolicy(int cacheSeconds) {
        try {
            InetAddressCacheUtilCommons.setDnsCachePolicy(cacheSeconds);
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to setDnsCachePolicy, cause: " + e, e);
        }
    }

    public static int getDnsNegativeCachePolicy() {
        try {
            return InetAddressCacheUtilCommons.getDnsNegativeCachePolicy();
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to getDnsNegativeCachePolicy, cause: " + e, e);
        }
    }

    public static void setDnsNegativeCachePolicy(int negativeCacheSeconds) {
        try {
            InetAddressCacheUtilCommons.setDnsNegativeCachePolicy(negativeCacheSeconds);
        }
        catch (Exception e) {
            throw new DnsCacheManipulatorException("Fail to setDnsNegativeCachePolicy, cause: " + e, e);
        }
    }

    private DnsCacheManipulator() {
    }
}

