/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.spring.boot.autoconfigure;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.datasource.druid")
public class DruidDataSourceWrapper
extends DruidDataSource
implements InitializingBean {
    @Autowired
    private DataSourceProperties basicProperties;

    public void afterPropertiesSet() throws Exception {
        if (super.getUsername() == null) {
            super.setUsername(this.basicProperties.determineUsername());
        }
        if (super.getPassword() == null) {
            super.setPassword(this.basicProperties.determinePassword());
        }
        if (super.getUrl() == null) {
            super.setUrl(this.basicProperties.determineUrl());
        }
        if (super.getDriverClassName() == null) {
            super.setDriverClassName(this.basicProperties.getDriverClassName());
        }
    }

    @Autowired(required=false)
    public void autoAddFilters(List<Filter> filters) {
        this.filters.addAll(filters);
    }

    public void setMaxEvictableIdleTimeMillis(long maxEvictableIdleTimeMillis) {
        try {
            super.setMaxEvictableIdleTimeMillis(maxEvictableIdleTimeMillis);
        }
        catch (IllegalArgumentException ignore) {
            this.maxEvictableIdleTimeMillis = maxEvictableIdleTimeMillis;
        }
    }
}

