/*
 * Copyright 1999-2011 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.druid.pool.ha;

import java.sql.Connection;

public class MultiConnectionHolder {

    private final Connection       connection;
    private final DataSourceHolder dataSourceHolder;

    public MultiConnectionHolder(DataSourceHolder dataSourceHolder, Connection connection){
        super();
        this.dataSourceHolder = dataSourceHolder;
        this.connection = connection;
    }

    public Connection getConnection() {
        return connection;
    }

    public DataSourceHolder getDataSourceHolder() {
        return dataSourceHolder;
    }

}
