/*
 * Copyright 1999-2011 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.druid.pool.ha.balance;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

import com.alibaba.druid.pool.ha.DataSourceChangedEvent;
import com.alibaba.druid.pool.ha.DataSourceHolder;
import com.alibaba.druid.pool.ha.MultiConnectionHolder;
import com.alibaba.druid.pool.ha.MultiDataSource;
import com.alibaba.druid.pool.ha.MultiDataSourceConnection;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;

public class RoundRobinBlancer extends AbstractBalancer {

    private final static Log    LOG             = LogFactory.getLog(RoundRobinBlancer.class);

    private final AtomicInteger indexErrorCount = new AtomicInteger();

    public RoundRobinBlancer(){

    }

    public void afterDataSourceChanged(DataSourceChangedEvent event) {

    }

    @Override
    public MultiConnectionHolder getConnection(MultiDataSourceConnection conn, String sql) throws SQLException {
        MultiDataSource multiDataSource = conn.getMultiDataSource();

        int size = multiDataSource.getDataSources().size();
        long connectionId = (int) conn.getId();

        if (size == 0) {
            throw new SQLException("can not get connection, no availabe datasources");
        }

        int index = (int) (connectionId % size);

        DataSourceHolder first = null;
        DataSourceHolder dataSource = null;

        try {
            int itemIndex = 0;
            for (DataSourceHolder item : multiDataSource.getDataSources().values()) {
                if (!item.isEnable()) {
                    continue;
                }

                if (first == null) {
                    first = item;
                }

                if (itemIndex == index) {
                    dataSource = item;
                    break;
                }
                itemIndex++;
            }

            if (dataSource == null) {
                dataSource = first;
            }
        } catch (Exception ex) {
            indexErrorCount.incrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("getDataSource error, index : " + index, ex);
            }
        }

        if (dataSource == null) {
            throw new SQLException("can not get real connection.");
        }

        MultiConnectionHolder holder = null;

        return holder;
    }

    public long getIndexErrorCount() {
        return indexErrorCount.get();
    }
}
