/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.model;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

final class RowHeaderRenderer
extends JLabel
implements TableCellRenderer,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JTable reftable;
    private JTable tableShow;
    private ArrayList<String> headerList;
    private int rowHeightNow;
    private int rowSpan;

    public RowHeaderRenderer(JTable reftable, JTable tableShow) {
        this(null, reftable, tableShow, 0);
    }

    public RowHeaderRenderer(ArrayList<String> headerList, JTable reftable, JTable tableShow, int rowSpan) {
        this.headerList = headerList;
        this.reftable = reftable;
        this.tableShow = tableShow;
        ListSelectionModel listModel = reftable.getSelectionModel();
        listModel.addListSelectionListener(this);
        this.rowHeightNow = reftable.getRowCount() * reftable.getRowHeight();
        this.rowSpan = rowSpan;
        if (rowSpan > 1) {
            this.rowHeightNow = rowSpan * reftable.getRowHeight();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int col) {
        int rowCountNow = this.reftable.getRowCount() / this.rowSpan;
        ((DefaultTableModel)table.getModel()).setRowCount(rowCountNow);
        JTableHeader header = this.reftable.getTableHeader();
        this.setOpaque(true);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalAlignment(0);
        this.setBackground(header.getBackground());
        if (this.isSelect(row)) {
            this.setForeground(Color.white);
            this.setBackground(Color.lightGray);
        } else {
            this.setForeground(header.getForeground());
        }
        this.setFont(header.getFont());
        if (row <= rowCountNow) {
            this.showCol(row);
        }
        return this;
    }

    private void showCol(int row) {
        String text = null;
        text = this.headerList != null && row < this.headerList.size() ? this.headerList.get(row) : String.valueOf(row + 1);
        if (this.rowSpan > 1) {
            this.setText(text);
            this.tableShow.setRowHeight(row, this.rowHeightNow);
        } else {
            this.setText(text);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.tableShow.repaint();
    }

    private boolean isSelect(int row) {
        int[] sel = this.reftable.getSelectedRows();
        if (this.rowSpan <= 1) {
            int len = sel.length;
            for (int i = 0; i < len; ++i) {
                if (sel[i] != row) continue;
                return true;
            }
        } else {
            int len = sel.length;
            for (int i = 0; i < len; ++i) {
                if (sel[i] / this.rowSpan != row) continue;
                return true;
            }
        }
        return false;
    }
}

