/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.proxy.jdbc.WrapperProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

public final class DruidConnectionHolder {
    private static final Log LOG = LogFactory.getLog(DruidConnectionHolder.class);
    public static boolean holdabilityUnsupported = false;
    protected final DruidAbstractDataSource dataSource;
    protected final long connectionId;
    protected final Connection conn;
    protected final List<ConnectionEventListener> connectionEventListeners;
    protected final List<StatementEventListener> statementEventListeners;
    protected final long connectTimeMillis;
    protected volatile long lastActiveTimeMillis;
    protected volatile long lastKeepTimeMillis;
    protected volatile long lastValidTimeMillis;
    protected long useCount;
    private long keepAliveCheckCount;
    private long lastNotEmptyWaitNanos;
    private final long createNanoSpan;
    protected PreparedStatementPool statementPool;
    protected final List<Statement> statementTrace;
    protected final boolean defaultReadOnly;
    protected final int defaultHoldability;
    protected final int defaultTransactionIsolation;
    protected final boolean defaultAutoCommit;
    protected boolean underlyingReadOnly;
    protected int underlyingHoldability;
    protected int underlyingTransactionIsolation;
    protected boolean underlyingAutoCommit;
    protected boolean discard;
    protected final Map<String, Object> variables;
    protected final Map<String, Object> globleVariables;
    final ReentrantLock lock;

    public DruidConnectionHolder(DruidAbstractDataSource dataSource, DruidAbstractDataSource.PhysicalConnectionInfo pyConnectInfo) throws SQLException {
        this(dataSource, pyConnectInfo.getPhysicalConnection(), pyConnectInfo.getConnectNanoSpan(), pyConnectInfo.getVairiables(), pyConnectInfo.getGlobalVairiables());
    }

    public DruidConnectionHolder(DruidAbstractDataSource dataSource, Connection conn, long connectNanoSpan) throws SQLException {
        this(dataSource, conn, connectNanoSpan, null, null);
    }

    public DruidConnectionHolder(DruidAbstractDataSource dataSource, Connection conn, long connectNanoSpan, Map<String, Object> variables, Map<String, Object> globleVariables) throws SQLException {
        block9: {
            boolean initUnderlyHoldability;
            this.connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
            this.statementEventListeners = new CopyOnWriteArrayList<StatementEventListener>();
            this.useCount = 0L;
            this.keepAliveCheckCount = 0L;
            this.statementTrace = new ArrayList<Statement>(2);
            this.discard = false;
            this.lock = new ReentrantLock();
            this.dataSource = dataSource;
            this.conn = conn;
            this.createNanoSpan = connectNanoSpan;
            this.variables = variables;
            this.globleVariables = globleVariables;
            this.lastActiveTimeMillis = this.connectTimeMillis = System.currentTimeMillis();
            this.underlyingAutoCommit = conn.getAutoCommit();
            this.connectionId = conn instanceof WrapperProxy ? ((WrapperProxy)((Object)conn)).getId() : dataSource.createConnectionId();
            boolean bl = initUnderlyHoldability = !holdabilityUnsupported;
            if ("sybase".equals(dataSource.dbType) || "db2".equals(dataSource.dbType) || "hive".equals(dataSource.dbType) || "odps".equals(dataSource.dbType)) {
                initUnderlyHoldability = false;
            }
            if (initUnderlyHoldability) {
                try {
                    this.underlyingHoldability = conn.getHoldability();
                }
                catch (UnsupportedOperationException e) {
                    holdabilityUnsupported = true;
                    LOG.warn("getHoldability unsupported", e);
                }
                catch (SQLFeatureNotSupportedException e) {
                    holdabilityUnsupported = true;
                    LOG.warn("getHoldability unsupported", e);
                }
                catch (SQLException e) {
                    if ("Method not supported".equals(e.getMessage())) {
                        holdabilityUnsupported = true;
                    }
                    LOG.warn("getHoldability error", e);
                }
            }
            this.underlyingReadOnly = conn.isReadOnly();
            try {
                this.underlyingTransactionIsolation = conn.getTransactionIsolation();
            }
            catch (SQLException e) {
                if ("HY000".equals(e.getSQLState()) || "com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException".equals(e.getClass().getName())) break block9;
                throw e;
            }
        }
        this.defaultHoldability = this.underlyingHoldability;
        this.defaultTransactionIsolation = this.underlyingTransactionIsolation;
        this.defaultAutoCommit = this.underlyingAutoCommit;
        this.defaultReadOnly = this.underlyingReadOnly;
    }

    public boolean isUnderlyingReadOnly() {
        return this.underlyingReadOnly;
    }

    public void setUnderlyingReadOnly(boolean underlyingReadOnly) {
        this.underlyingReadOnly = underlyingReadOnly;
    }

    public int getUnderlyingHoldability() {
        return this.underlyingHoldability;
    }

    public void setUnderlyingHoldability(int underlyingHoldability) {
        this.underlyingHoldability = underlyingHoldability;
    }

    public int getUnderlyingTransactionIsolation() {
        return this.underlyingTransactionIsolation;
    }

    public void setUnderlyingTransactionIsolation(int underlyingTransactionIsolation) {
        this.underlyingTransactionIsolation = underlyingTransactionIsolation;
    }

    public boolean isUnderlyingAutoCommit() {
        return this.underlyingAutoCommit;
    }

    public void setUnderlyingAutoCommit(boolean underlyingAutoCommit) {
        this.underlyingAutoCommit = underlyingAutoCommit;
    }

    public long getLastActiveTimeMillis() {
        return this.lastActiveTimeMillis;
    }

    public void setLastActiveTimeMillis(long lastActiveMillis) {
        this.lastActiveTimeMillis = lastActiveMillis;
    }

    public void addTrace(DruidPooledStatement stmt) {
        this.lock.lock();
        try {
            this.statementTrace.add(stmt);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeTrace(DruidPooledStatement stmt) {
        this.lock.lock();
        try {
            this.statementTrace.remove(stmt);
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ConnectionEventListener> getConnectionEventListeners() {
        return this.connectionEventListeners;
    }

    public List<StatementEventListener> getStatementEventListeners() {
        return this.statementEventListeners;
    }

    public PreparedStatementPool getStatementPool() {
        if (this.statementPool == null) {
            this.statementPool = new PreparedStatementPool(this);
        }
        return this.statementPool;
    }

    public PreparedStatementPool getStatementPoolDirect() {
        return this.statementPool;
    }

    public void clearStatementCache() {
        if (this.statementPool == null) {
            return;
        }
        this.statementPool.clear();
    }

    public DruidAbstractDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPoolPreparedStatements() {
        return this.dataSource.isPoolPreparedStatements();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public long getTimeMillis() {
        return this.connectTimeMillis;
    }

    public long getUseCount() {
        return this.useCount;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public void incrementUseCount() {
        ++this.useCount;
    }

    public long getKeepAliveCheckCount() {
        return this.keepAliveCheckCount;
    }

    public void incrementKeepAliveCheckCount() {
        ++this.keepAliveCheckCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SQLException {
        if (this.underlyingReadOnly != this.defaultReadOnly) {
            this.conn.setReadOnly(this.defaultReadOnly);
            this.underlyingReadOnly = this.defaultReadOnly;
        }
        if (this.underlyingHoldability != this.defaultHoldability) {
            this.conn.setHoldability(this.defaultHoldability);
            this.underlyingHoldability = this.defaultHoldability;
        }
        if (this.underlyingTransactionIsolation != this.defaultTransactionIsolation) {
            this.conn.setTransactionIsolation(this.defaultTransactionIsolation);
            this.underlyingTransactionIsolation = this.defaultTransactionIsolation;
        }
        if (this.underlyingAutoCommit != this.defaultAutoCommit) {
            this.conn.setAutoCommit(this.defaultAutoCommit);
            this.underlyingAutoCommit = this.defaultAutoCommit;
        }
        this.connectionEventListeners.clear();
        this.statementEventListeners.clear();
        this.lock.lock();
        try {
            for (Object item : this.statementTrace.toArray()) {
                Statement stmt = (Statement)item;
                JdbcUtils.close(stmt);
            }
            this.statementTrace.clear();
        }
        finally {
            this.lock.unlock();
        }
        this.conn.clearWarnings();
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean discard) {
        this.discard = discard;
    }

    public long getCreateNanoSpan() {
        return this.createNanoSpan;
    }

    public long getLastNotEmptyWaitNanos() {
        return this.lastNotEmptyWaitNanos;
    }

    protected void setLastNotEmptyWaitNanos(long lastNotEmptyWaitNanos) {
        this.lastNotEmptyWaitNanos = lastNotEmptyWaitNanos;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ID:");
        buf.append(System.identityHashCode(this.conn));
        buf.append(", ConnectTime:\"");
        buf.append(Utils.toString(new Date(this.connectTimeMillis)));
        buf.append("\", UseCount:");
        buf.append(this.useCount);
        if (this.lastActiveTimeMillis > 0L) {
            buf.append(", LastActiveTime:\"");
            buf.append(Utils.toString(new Date(this.lastActiveTimeMillis)));
            buf.append("\"");
        }
        if (this.lastKeepTimeMillis > 0L) {
            buf.append(", LastKeepTimeMillis:\"");
            buf.append(Utils.toString(new Date(this.lastKeepTimeMillis)));
            buf.append("\"");
        }
        if (this.statementPool != null && this.statementPool.getMap().size() > 0) {
            buf.append("\", CachedStatementCount:");
            buf.append(this.statementPool.getMap().size());
        }
        buf.append("}");
        return buf.toString();
    }
}

