/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole;

import com.alibaba.druid.support.jconsole.model.DruidTableCellRenderer;
import com.alibaba.druid.support.jconsole.model.DruidTableModel;
import com.alibaba.druid.support.jconsole.util.TableDataProcessor;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class DruidSqlDetailFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String BASE_URL = "/sql";
    private static final String KEY_FORMAT_SQL = "formattedSql";
    private static final String KEY_SQL = "SQL";
    private String id;
    private MBeanServerConnection conn;
    private static final ArrayList<String> PARESE_TITLE_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("parsedTable");
            this.add("parsedFields");
            this.add("parsedConditions");
            this.add("parsedRelationships");
            this.add("parsedOrderbycolumns");
        }
    };
    private static final ArrayList<String> LAST_SLOW_TITLE_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("MaxTimespan");
            this.add("MaxTimespanOccurTime");
            this.add("LastSlowParameters");
        }
    };
    private static final ArrayList<String> LAST_ERROR_TITLE_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("LastErrorMessage");
            this.add("LastErrorClass");
            this.add("LastErrorTime");
            this.add("LastErrorStackTrace");
        }
    };
    private static final ArrayList<String> OTHER_ERROR_TITLE_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("BatchSizeMax");
            this.add("BatchSizeTotal");
            this.add("BlobOpenCount");
            this.add("ClobOpenCount");
            this.add("ReaderOpenCount");
            this.add("InputStreamOpenCount");
            this.add("ReadStringLength");
            this.add("ReadBytesLength");
        }
    };
    private ArrayList<LinkedHashMap<String, Object>> parseData;
    private ArrayList<LinkedHashMap<String, Object>> lastSlowData;
    private ArrayList<LinkedHashMap<String, Object>> lastErrorData;
    private ArrayList<LinkedHashMap<String, Object>> otherData;
    private int maxListLen;
    private String formatSql;
    private String sql;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 600;
    private static final Log LOG = LogFactory.getLog(DruidSqlDetailFrame.class);

    public DruidSqlDetailFrame(String id, MBeanServerConnection conn) {
        this.id = id;
        this.conn = conn;
        this.getMaxListLen();
        this.init();
        this.start();
    }

    private void getMaxListLen() {
        this.maxListLen = PARESE_TITLE_LIST.size();
        int slowLen = LAST_SLOW_TITLE_LIST.size();
        int errLen = LAST_ERROR_TITLE_LIST.size();
        int otherLen = OTHER_ERROR_TITLE_LIST.size();
        if (this.maxListLen < slowLen) {
            this.maxListLen = slowLen;
        }
        if (this.maxListLen < errLen) {
            this.maxListLen = errLen;
        }
        if (this.maxListLen < otherLen) {
            this.maxListLen = otherLen;
        }
    }

    private void init() {
        String url = "/sql-" + this.id + ".json";
        try {
            ArrayList<LinkedHashMap<String, Object>> data = TableDataProcessor.parseData(TableDataProcessor.getData(url, this.conn));
            if (data != null) {
                LinkedHashMap<String, Object> contentEle = data.get(0);
                this.formatSql = (String)contentEle.remove(KEY_FORMAT_SQL);
                this.sql = (String)contentEle.remove(KEY_SQL);
                int parseLen = PARESE_TITLE_LIST.size();
                int slowLen = LAST_SLOW_TITLE_LIST.size();
                int errLen = LAST_ERROR_TITLE_LIST.size();
                int otherLen = OTHER_ERROR_TITLE_LIST.size();
                LinkedHashMap<String, Object> parseDataEle = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, Object> slowDataEle = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, Object> errDataEle = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, Object> otherDataEle = new LinkedHashMap<String, Object>();
                this.parseData = new ArrayList(1);
                this.lastSlowData = new ArrayList(1);
                this.lastErrorData = new ArrayList(1);
                this.otherData = new ArrayList(1);
                for (Map.Entry<String, Object> entry : contentEle.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    for (int i = 0; i < this.maxListLen; ++i) {
                        if (i < parseLen && key.equals(PARESE_TITLE_LIST.get(i))) {
                            parseDataEle.put(key, value);
                            continue;
                        }
                        if (i < slowLen && key.equals(LAST_SLOW_TITLE_LIST.get(i))) {
                            slowDataEle.put(key, value);
                            continue;
                        }
                        if (i < errLen && key.equals(LAST_ERROR_TITLE_LIST.get(i))) {
                            errDataEle.put(key, value);
                            continue;
                        }
                        if (i >= otherLen || !key.equals(OTHER_ERROR_TITLE_LIST.get(i))) continue;
                        otherDataEle.put(key, value);
                    }
                }
                this.parseData.add(parseDataEle);
                this.lastSlowData.add(slowDataEle);
                this.lastErrorData.add(errDataEle);
                this.otherData.add(otherDataEle);
            } else {
                LOG.warn("\u9519\u8bef\u7684json\u683c\u5f0f");
            }
        }
        catch (Exception e) {
            LOG.warn("\u83b7\u53d6\u6570\u636e\u65f6\u5f02\u5e38", e);
        }
    }

    private void addTable(JPanel contentPanel, String title, ArrayList<LinkedHashMap<String, Object>> data) {
        JPanel content1 = new JPanel();
        content1.setLayout(new BorderLayout());
        content1.setBorder(BorderFactory.createTitledBorder(title));
        contentPanel.add(content1);
        TableDataProcessor.ColumnData colData = TableDataProcessor.row2col(data);
        JTable table = new JTable();
        DruidTableModel tableModel = new DruidTableModel(colData.getData());
        table.setModel(tableModel);
        TableColumn col = table.getColumnModel().getColumn(0);
        col.setCellRenderer(new DruidTableCellRenderer());
        JTableHeader header1 = table.getTableHeader();
        content1.add((Component)header1, "North");
        content1.add(table);
    }

    private void addComponentsToPane(Container pane) {
        JScrollPane scrollPane = new JScrollPane();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridLayout(0, 1));
        JTextArea sqlField = new JTextArea(this.formatSql, 8, 20);
        JScrollPane content1 = new JScrollPane(sqlField);
        content1.setBorder(BorderFactory.createTitledBorder("SQL\u8bed\u53e5"));
        contentPanel.add(content1);
        this.addTable(contentPanel, "\u89e3\u6790\u4fe1\u606f", this.parseData);
        this.addTable(contentPanel, "\u4e0a\u6b21\u6162\u67e5\u8be2\u4fe1\u606f", this.lastSlowData);
        this.addTable(contentPanel, "\u4e0a\u6b21\u9519\u8bef\u67e5\u8be2\u4fe1\u606f", this.lastErrorData);
        this.addTable(contentPanel, "\u5176\u4ed6\u4fe1\u606f", this.otherData);
        scrollPane.setViewportView(contentPanel);
        pane.add((Component)scrollPane, "Center");
    }

    private void start() {
        this.addComponentsToPane(this.getContentPane());
        this.setTitle("SQL:[" + this.sql + "]\u8be6\u60c5");
        this.pack();
        this.setSize(800, 600);
        double width = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double height = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        this.setLocation((int)(width - (double)this.getWidth()) / 2, (int)(height - (double)this.getHeight()) / 2);
        this.setVisible(true);
    }
}

