/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.sql.repository.Schema;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.repository.SchemaObjectImpl;
import com.alibaba.druid.sql.repository.SchemaObjectType;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.repository.SchemaResolveVisitorFactory;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SchemaRepository {
    private static Log LOG = LogFactory.getLog(SchemaRepository.class);
    private Schema defaultSchema;
    protected String dbType;
    protected SQLASTVisitor consoleVisitor;
    private Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();

    public SchemaRepository() {
    }

    public SchemaRepository(String dbType) {
        this.dbType = dbType;
        this.consoleVisitor = "mysql".equals(dbType) || "oceanbase".equals(dbType) ? new MySqlConsoleSchemaVisitor() : ("oracle".equals(dbType) || "oceanbase_oracle".equals(dbType) ? new OracleConsoleSchemaVisitor() : new DefaultConsoleSchemaVisitor());
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getDefaultSchemaName() {
        return this.getDefaultSchema().getName();
    }

    public void setDefaultSchema(String name) {
        if (name == null) {
            this.defaultSchema = null;
            return;
        }
        String normalizedName = SQLUtils.normalize(name).toLowerCase();
        Schema defaultSchema = this.schemas.get(normalizedName);
        if (defaultSchema != null) {
            this.defaultSchema = defaultSchema;
            return;
        }
        if (defaultSchema == null) {
            if (this.defaultSchema != null && this.defaultSchema.getName() == null) {
                this.defaultSchema.setName(name);
                this.schemas.put(normalizedName, this.defaultSchema);
                return;
            }
            defaultSchema = new Schema(this);
            defaultSchema.setName(name);
            this.schemas.put(normalizedName, defaultSchema);
            this.defaultSchema = defaultSchema;
        }
    }

    public Schema findSchema(String schema) {
        return this.findSchema(schema, false);
    }

    protected Schema findSchema(String name, boolean create) {
        if (name == null || name.length() == 0) {
            return this.getDefaultSchema();
        }
        name = SQLUtils.normalize(name);
        String normalizedName = name.toLowerCase();
        if (this.getDefaultSchema() != null && this.defaultSchema.getName() == null) {
            this.defaultSchema.setName(name);
            this.schemas.put(normalizedName, this.defaultSchema);
            return this.defaultSchema;
        }
        Schema schema = this.schemas.get(normalizedName);
        if (schema == null) {
            schema = new Schema(this, name);
            this.schemas.put(normalizedName, schema);
        }
        return schema;
    }

    public Schema getDefaultSchema() {
        if (this.defaultSchema == null) {
            this.defaultSchema = new Schema(this);
        }
        return this.defaultSchema;
    }

    public void setDefaultSchema(Schema schema) {
        this.defaultSchema = schema;
    }

    public SchemaObject findTable(String tableName) {
        return this.getDefaultSchema().findTable(tableName);
    }

    public SchemaObject findTableOrView(String tableName) {
        return this.findTableOrView(tableName, true);
    }

    public SchemaObject findTableOrView(String tableName, boolean onlyCurrent) {
        Schema schema = this.getDefaultSchema();
        SchemaObject object = schema.findTableOrView(tableName);
        if (object != null) {
            return object;
        }
        for (Schema s : this.schemas.values()) {
            if (s == schema || (object = schema.findTableOrView(tableName)) == null) continue;
            return object;
        }
        return null;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    public SchemaObject findFunction(String functionName) {
        return this.getDefaultSchema().findFunction(functionName);
    }

    public void acceptDDL(String ddl) {
        this.acceptDDL(ddl, this.dbType);
    }

    public void acceptDDL(String ddl, String dbType) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddl, dbType);
        for (SQLStatement stmt : stmtList) {
            this.accept(stmt);
        }
    }

    public void accept(SQLStatement stmt) {
        stmt.accept(this.consoleVisitor);
    }

    public boolean isSequence(String name) {
        return this.getDefaultSchema().isSequence(name);
    }

    public SchemaObject findTable(SQLTableSource tableSource, String alias) {
        return this.getDefaultSchema().findTable(tableSource, alias);
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLSelectItem selectItem) {
        return this.getDefaultSchema().findColumn(tableSource, selectItem);
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLExpr expr) {
        return this.getDefaultSchema().findColumn(tableSource, expr);
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLSelectItem selectItem) {
        return this.getDefaultSchema().findTable(tableSource, selectItem);
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLExpr expr) {
        return this.getDefaultSchema().findTable(tableSource, expr);
    }

    public Map<String, SchemaObject> getTables(SQLTableSource x) {
        return this.getDefaultSchema().getTables(x);
    }

    public int getTableCount() {
        return this.getDefaultSchema().getTableCount();
    }

    public Collection<SchemaObject> getObjects() {
        return this.getDefaultSchema().getObjects();
    }

    public int getViewCount() {
        return this.getDefaultSchema().getViewCount();
    }

    public void resolve(SQLSelectStatement stmt, SchemaResolveVisitor.Option ... options) {
        if (stmt == null) {
            return;
        }
        SchemaResolveVisitor resolveVisitor = this.createResolveVisitor(options);
        resolveVisitor.visit(stmt);
    }

    public void resolve(SQLStatement stmt, SchemaResolveVisitor.Option ... options) {
        if (stmt == null) {
            return;
        }
        SchemaResolveVisitor resolveVisitor = this.createResolveVisitor(options);
        stmt.accept(resolveVisitor);
    }

    private SchemaResolveVisitor createResolveVisitor(SchemaResolveVisitor.Option ... options) {
        int optionsValue = SchemaResolveVisitor.Option.of(options);
        SQLASTVisitorAdapter resolveVisitor = JdbcUtils.isMysqlDbType(this.dbType) || "sqlite".equals(this.dbType) ? new SchemaResolveVisitorFactory.MySqlResolveVisitor(this, optionsValue) : (JdbcUtils.isOracleDbType(this.dbType) ? new SchemaResolveVisitorFactory.OracleResolveVisitor(this, optionsValue) : (JdbcUtils.isPgsqlDbType(this.dbType) ? new SchemaResolveVisitorFactory.PGResolveVisitor(this, optionsValue) : (JdbcUtils.isSqlserverDbType(this.dbType) ? new SchemaResolveVisitorFactory.SQLServerResolveVisitor(this, optionsValue) : ("db2".equals(this.dbType) ? new SchemaResolveVisitorFactory.DB2ResolveVisitor(this, optionsValue) : ("odps".equals(this.dbType) ? new SchemaResolveVisitorFactory.OdpsResolveVisitor(this, optionsValue) : ("hive".equals(this.dbType) ? new SchemaResolveVisitorFactory.HiveResolveVisitor(this, optionsValue) : new SchemaResolveVisitorFactory.SQLResolveVisitor(this, optionsValue)))))));
        return resolveVisitor;
    }

    public String resolve(String input) {
        SchemaResolveVisitor visitor = this.createResolveVisitor(SchemaResolveVisitor.Option.ResolveAllColumn, SchemaResolveVisitor.Option.ResolveIdentifierAlias);
        List<SQLStatement> stmtList = SQLUtils.parseStatements(input, this.dbType);
        for (SQLStatement stmt : stmtList) {
            stmt.accept(visitor);
        }
        return SQLUtils.toSQLString(stmtList, this.dbType);
    }

    public String console(String input) {
        try {
            StringBuffer buf = new StringBuffer();
            List<SQLStatement> stmtList = SQLUtils.parseStatements(input, this.dbType);
            for (SQLStatement stmt : stmtList) {
                Schema schema;
                if (stmt instanceof MySqlShowColumnsStatement) {
                    MySqlShowColumnsStatement showColumns = (MySqlShowColumnsStatement)stmt;
                    SQLName db = showColumns.getDatabase();
                    schema = db == null ? this.getDefaultSchema() : this.findSchema(db.getSimpleName());
                    SQLName table = null;
                    SchemaObject schemaObject = null;
                    if (schema != null) {
                        table = showColumns.getTable();
                        schemaObject = schema.findTable(table.nameHashCode64());
                    }
                    if (schemaObject == null) {
                        buf.append("ERROR 1146 (42S02): Table '" + table + "' doesn't exist\n");
                        continue;
                    }
                    MySqlCreateTableStatement createTableStmt = (MySqlCreateTableStatement)schemaObject.getStatement();
                    createTableStmt.showCoumns(buf);
                    continue;
                }
                if (stmt instanceof MySqlShowCreateTableStatement) {
                    MySqlShowCreateTableStatement showCreateTableStmt = (MySqlShowCreateTableStatement)stmt;
                    SQLName table = showCreateTableStmt.getName();
                    SchemaObject schemaObject = this.findTable(table);
                    if (schemaObject == null) {
                        buf.append("ERROR 1146 (42S02): Table '" + table + "' doesn't exist\n");
                        continue;
                    }
                    MySqlCreateTableStatement createTableStmt = (MySqlCreateTableStatement)schemaObject.getStatement();
                    createTableStmt.output(buf);
                    continue;
                }
                if (stmt instanceof MySqlRenameTableStatement) {
                    MySqlRenameTableStatement renameStmt = (MySqlRenameTableStatement)stmt;
                    for (MySqlRenameTableStatement.Item item : renameStmt.getItems()) {
                        this.renameTable(item.getName(), item.getTo());
                    }
                    continue;
                }
                if (stmt instanceof SQLShowTablesStatement) {
                    SQLShowTablesStatement showTables = (SQLShowTablesStatement)stmt;
                    SQLName database = showTables.getDatabase();
                    schema = database == null ? this.getDefaultSchema() : this.findSchema(database.getSimpleName());
                    if (schema == null) continue;
                    for (String table : schema.showTables()) {
                        buf.append(table);
                        buf.append('\n');
                    }
                    continue;
                }
                stmt.accept(this.consoleVisitor);
            }
            if (buf.length() == 0) {
                return "\n";
            }
            return buf.toString();
        }
        catch (IOException ex) {
            throw new DruidRuntimeException("exeucte command error.", ex);
        }
    }

    public SchemaObject findTable(SQLName name) {
        if (name instanceof SQLIdentifierExpr) {
            return this.findTable(((SQLIdentifierExpr)name).getName());
        }
        if (name instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)name;
            String schema = propertyExpr.getOwnernName();
            long tableHashCode64 = propertyExpr.nameHashCode64();
            Schema schemaObj = this.findSchema(schema);
            if (schemaObj == null) {
                return null;
            }
            return schemaObj.findTable(tableHashCode64);
        }
        return null;
    }

    private boolean renameTable(SQLName name, SQLName to) {
        Schema schema;
        if (name instanceof SQLPropertyExpr) {
            String schemaName = ((SQLPropertyExpr)name).getOwnernName();
            schema = this.findSchema(schemaName);
        } else {
            schema = this.getDefaultSchema();
        }
        if (schema == null) {
            return false;
        }
        long nameHashCode64 = name.nameHashCode64();
        SchemaObject schemaObject = schema.findTable(nameHashCode64);
        if (schemaObject != null) {
            MySqlCreateTableStatement createTableStmt = (MySqlCreateTableStatement)schemaObject.getStatement();
            if (createTableStmt != null) {
                createTableStmt.setName(to.clone());
            }
            schema.objects.put(to.hashCode64(), schemaObject);
            schema.objects.remove(nameHashCode64);
        }
        return true;
    }

    public SchemaObject findTable(SQLExprTableSource x) {
        if (x == null) {
            return null;
        }
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLName) {
            return this.findTable((SQLName)expr);
        }
        return null;
    }

    boolean acceptCreateTable(MySqlCreateTableStatement x) {
        SchemaObject table;
        SQLExprTableSource like = x.getLike();
        if (like != null && (table = this.findTable((SQLName)like.getExpr())) != null) {
            MySqlCreateTableStatement stmt = (MySqlCreateTableStatement)table.getStatement();
            MySqlCreateTableStatement stmtCloned = stmt.clone();
            stmtCloned.setName(x.getName().clone());
            this.acceptCreateTable((SQLCreateTableStatement)stmtCloned);
            return false;
        }
        return this.acceptCreateTable((SQLCreateTableStatement)x);
    }

    boolean acceptCreateTable(SQLCreateTableStatement x) {
        SQLExprTableSource like;
        SQLCreateTableStatement x1 = x.clone();
        String schemaName = x1.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SQLSelect select = x1.getSelect();
        if (select != null) {
            select.accept(this.createResolveVisitor(SchemaResolveVisitor.Option.ResolveAllColumn));
            SQLSelectQueryBlock queryBlock = select.getFirstQueryBlock();
            if (queryBlock != null) {
                List<SQLSelectItem> selectList = queryBlock.getSelectList();
                for (SQLSelectItem selectItem : selectList) {
                    SQLExpr selectItemExpr = selectItem.getExpr();
                    if (selectItemExpr instanceof SQLAllColumnExpr || selectItemExpr instanceof SQLPropertyExpr && ((SQLPropertyExpr)selectItemExpr).getName().equals("*")) continue;
                    String name = selectItem.computeAlias();
                    SQLDataType dataType = selectItem.computeDataType();
                    SQLColumnDefinition column = new SQLColumnDefinition();
                    column.setName(name);
                    column.setDataType(dataType);
                    column.setDbType(this.dbType);
                    x1.getTableElementList().add(column);
                }
                if (x1.getTableElementList().size() > 0) {
                    x1.setSelect(null);
                }
            }
        }
        if ((like = x1.getLike()) != null) {
            SQLStatement stmt;
            SchemaObject tableObject = null;
            SQLName name = like.getName();
            if (name != null) {
                tableObject = this.findTable(name);
            }
            SQLCreateTableStatement tableStmt = null;
            if (tableObject != null && (stmt = tableObject.getStatement()) instanceof SQLCreateTableStatement) {
                tableStmt = (SQLCreateTableStatement)stmt;
            }
            if (tableStmt != null) {
                SQLName tableName = x1.getName();
                tableStmt.cloneTo(x1);
                x1.setName(tableName);
                x1.setLike((SQLExprTableSource)null);
            }
        }
        x1.setSchema(null);
        String name = x1.computeName();
        SchemaObject table = schema.findTableOrView(name);
        if (table != null) {
            LOG.info("replaced table '" + name + "'");
        }
        table = new SchemaObjectImpl(name, SchemaObjectType.Table, x1);
        schema.objects.put(table.nameHashCode64(), table);
        return true;
    }

    boolean acceptDropTable(SQLDropTableStatement x) {
        for (SQLExprTableSource table : x.getTableSources()) {
            String schemaName = table.getSchema();
            Schema schema = this.findSchema(schemaName, false);
            if (schema == null) continue;
            long nameHashCode64 = table.getName().nameHashCode64();
            schema.objects.remove(nameHashCode64);
        }
        return true;
    }

    boolean acceptView(SQLCreateViewStatement x) {
        String name;
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SchemaObject view = schema.findTableOrView(name = x.computeName());
        if (view != null) {
            return false;
        }
        SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.View, x.clone());
        schema.objects.put(object.nameHashCode64(), object);
        return true;
    }

    boolean acceptView(SQLAlterViewStatement x) {
        String name;
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SchemaObject view = schema.findTableOrView(name = x.computeName());
        if (view != null) {
            return false;
        }
        SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.View, x.clone());
        schema.objects.put(object.nameHashCode64(), object);
        return true;
    }

    boolean acceptDropIndex(SQLDropIndexStatement x) {
        SQLCreateTableStatement stmt;
        SQLName table = x.getTableName().getName();
        SchemaObject object = this.findTable(table);
        if (object != null && (stmt = (SQLCreateTableStatement)object.getStatement()) != null) {
            stmt.apply(x);
            return true;
        }
        return false;
    }

    boolean acceptCreateIndex(SQLCreateIndexStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        String name = x.getName().getSimpleName();
        SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.Index, x.clone());
        schema.objects.put(object.nameHashCode64(), object);
        return true;
    }

    boolean acceptCreateFunction(SQLCreateFunctionStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        String name = x.getName().getSimpleName();
        SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.Function, x.clone());
        schema.functions.put(object.nameHashCode64(), object);
        return true;
    }

    boolean acceptAlterTable(SQLAlterTableStatement x) {
        SQLCreateTableStatement stmt;
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        SchemaObject object = schema.findTable(x.nameHashCode64());
        if (object != null && (stmt = (SQLCreateTableStatement)object.getStatement()) != null) {
            stmt.apply(x);
            return true;
        }
        return false;
    }

    public boolean acceptCreateSequence(SQLCreateSequenceStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        String name = x.getName().getSimpleName();
        SchemaObjectImpl object = new SchemaObjectImpl(name, SchemaObjectType.Sequence);
        schema.objects.put(object.nameHashCode64(), object);
        return false;
    }

    public boolean acceptDropSequence(SQLDropSequenceStatement x) {
        String schemaName = x.getSchema();
        Schema schema = this.findSchema(schemaName, true);
        long nameHashCode64 = x.getName().nameHashCode64();
        schema.objects.remove(nameHashCode64);
        return false;
    }

    public class DefaultConsoleSchemaVisitor
    extends SQLASTVisitorAdapter {
        @Override
        public boolean visit(SQLDropSequenceStatement x) {
            SchemaRepository.this.acceptDropSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateSequenceStatement x) {
            SchemaRepository.this.acceptCreateSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropTableStatement x) {
            SchemaRepository.this.acceptDropTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateIndexStatement x) {
            SchemaRepository.this.acceptCreateIndex(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            SchemaRepository.this.acceptCreateFunction(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaRepository.this.acceptAlterTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropIndexStatement x) {
            SchemaRepository.this.acceptDropIndex(x);
            return false;
        }
    }

    public class OracleConsoleSchemaVisitor
    extends OracleASTVisitorAdapter {
        @Override
        public boolean visit(SQLDropSequenceStatement x) {
            SchemaRepository.this.acceptDropSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateSequenceStatement x) {
            SchemaRepository.this.acceptCreateSequence(x);
            return false;
        }

        @Override
        public boolean visit(OracleCreateTableStatement x) {
            this.visit((SQLCreateTableStatement)x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropTableStatement x) {
            SchemaRepository.this.acceptDropTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateIndexStatement x) {
            SchemaRepository.this.acceptCreateIndex(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            SchemaRepository.this.acceptCreateFunction(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaRepository.this.acceptAlterTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLUseStatement x) {
            String schema = x.getDatabase().getSimpleName();
            SchemaRepository.this.setDefaultSchema(schema);
            return false;
        }

        @Override
        public boolean visit(SQLDropIndexStatement x) {
            SchemaRepository.this.acceptDropIndex(x);
            return false;
        }
    }

    public class MySqlConsoleSchemaVisitor
    extends MySqlASTVisitorAdapter {
        @Override
        public boolean visit(SQLDropSequenceStatement x) {
            SchemaRepository.this.acceptDropSequence(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateSequenceStatement x) {
            SchemaRepository.this.acceptCreateSequence(x);
            return false;
        }

        @Override
        public boolean visit(MySqlCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateTableStatement x) {
            SchemaRepository.this.acceptCreateTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLDropTableStatement x) {
            SchemaRepository.this.acceptDropTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterViewStatement x) {
            SchemaRepository.this.acceptView(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateIndexStatement x) {
            SchemaRepository.this.acceptCreateIndex(x);
            return false;
        }

        @Override
        public boolean visit(SQLCreateFunctionStatement x) {
            SchemaRepository.this.acceptCreateFunction(x);
            return false;
        }

        @Override
        public boolean visit(SQLAlterTableStatement x) {
            SchemaRepository.this.acceptAlterTable(x);
            return false;
        }

        @Override
        public boolean visit(SQLUseStatement x) {
            String schema = x.getDatabase().getSimpleName();
            SchemaRepository.this.setDefaultSchema(schema);
            return false;
        }

        @Override
        public boolean visit(SQLDropIndexStatement x) {
            SchemaRepository.this.acceptDropIndex(x);
            return false;
        }
    }
}

