/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.starrocks.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLIndexDefinition;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.dialect.starrocks.ast.statement.StarRocksCreateTableStatement;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksExprParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StarRocksCreateTableParser
extends SQLCreateTableParser {
    public StarRocksCreateTableParser(Lexer lexer) {
        super(new StarRocksExprParser(lexer));
    }

    public StarRocksCreateTableParser(String sql) {
        super(new StarRocksExprParser(sql));
    }

    public StarRocksCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        StarRocksCreateTableStatement createTable = this.newCreateStatement();
        createTable.setDbType(this.getDbType());
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                createTable.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.EXTERNAL)) {
            this.lexer.nextToken();
            createTable.setExternal(true);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DIMENSION)) {
            this.lexer.nextToken();
            createTable.setDimension(true);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            createTable.setIfNotExiists(true);
        }
        createTable.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token = this.lexer.token();
                if (this.lexer.identifierEquals(FnvHash.Constants.SUPPLEMENTAL) && DbType.oracle == this.dbType) {
                    SQLTableElement element = this.parseCreateTableSupplementalLogingProps();
                    element.setParent(createTable);
                    createTable.getTableElementList().add(element);
                } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn(createTable);
                    column.setParent(createTable);
                    createTable.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(createTable);
                    createTable.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    column = this.exprParser.parseColumn();
                    createTable.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.INHERITS)) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                createTable.setInherits(new SQLExprTableSource(inherits));
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            SQLSelect select = null;
            select = DbType.oracle == this.dbType ? new OracleSelectParser(this.exprParser).select() : this.createSQLSelectParser().select();
            createTable.setSelect(select);
        }
        if (this.lexer.token() == Token.WITH && DbType.postgresql == this.dbType) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.parseAssignItems(createTable.getTableOptions(), createTable, false);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.TABLESPACE) {
            this.lexer.nextToken();
            createTable.setTablespace(this.exprParser.name());
        }
        if (this.lexer.token() == Token.PARTITION) {
            SQLPartitionBy partitionClause = this.parsePartitionBy();
            createTable.setPartitioning(partitionClause);
        }
        this.parseCreateTableRest(createTable);
        return createTable;
    }

    @Override
    public void parseCreateTableRest(SQLCreateTableStatement stmt) {
        StarRocksCreateTableStatement srStmt;
        block18: {
            srStmt = (StarRocksCreateTableStatement)stmt;
            if (this.lexer.identifierEquals(FnvHash.Constants.ENGINE)) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.EQ) {
                    this.lexer.nextToken();
                }
                stmt.setEngine(this.exprParser.expr());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DUPLICATE) || this.lexer.identifierEquals(FnvHash.Constants.AGGREGATE) || this.lexer.identifierEquals(FnvHash.Constants.UNIQUE) || this.lexer.identifierEquals(FnvHash.Constants.PRIMARY)) {
                SQLName model = this.exprParser.name();
                this.accept(Token.KEY);
                SQLIndexDefinition modelKey = new SQLIndexDefinition();
                modelKey.setType(model.getSimpleName());
                modelKey.setKey(true);
                srStmt.setModelKey(modelKey);
                this.exprParser.parseIndexRest(modelKey, srStmt);
            }
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                srStmt.setComment(new SQLCharExpr(this.lexer.stringVal()));
                this.accept(this.lexer.token());
            }
            if (this.lexer.token() == Token.PARTITION) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                SQLExpr expr = this.exprParser.expr();
                srStmt.setPartitionBy(expr);
                this.accept(Token.LPAREN);
                if (this.lexer.token() == Token.PARTITION) {
                    Map<SQLExpr, List<SQLExpr>> fixedRangeMap;
                    while (true) {
                        Map<SQLExpr, SQLExpr> lessThanMap = srStmt.getLessThanMap();
                        fixedRangeMap = srStmt.getFixedRangeMap();
                        this.lexer.nextToken();
                        SQLExpr area = this.exprParser.expr();
                        this.accept(Token.VALUES);
                        if (this.lexer.identifierEquals(FnvHash.Constants.LESS)) {
                            srStmt.setLessThan(true);
                            this.lexer.nextToken();
                            if (!this.lexer.identifierEquals(FnvHash.Constants.THAN)) continue;
                            this.lexer.nextToken();
                            SQLExpr value = this.exprParser.expr();
                            lessThanMap.put(area, value);
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                            if (this.lexer.token() != Token.RPAREN) continue;
                            this.lexer.nextToken();
                            srStmt.setLessThanMap(lessThanMap);
                            break block18;
                        }
                        if (this.lexer.token() != Token.LBRACKET) continue;
                        this.lexer.nextToken();
                        srStmt.setFixedRange(true);
                        ArrayList<SQLExpr> valueList = new ArrayList<SQLExpr>();
                        while (true) {
                            SQLExpr value = this.exprParser.expr();
                            valueList.add(value);
                            if (this.lexer.token() == Token.COMMA) {
                                this.lexer.nextToken();
                                continue;
                            }
                            if (this.lexer.token() == Token.RPAREN) break;
                        }
                        this.lexer.nextToken();
                        fixedRangeMap.put(area, valueList);
                        if (this.lexer.token() == Token.COMMA) {
                            this.lexer.nextToken();
                            continue;
                        }
                        if (this.lexer.token() == Token.RPAREN) break;
                    }
                    this.lexer.nextToken();
                    srStmt.setFixedRangeMap(fixedRangeMap);
                } else if (this.lexer.identifierEquals(FnvHash.Constants.START)) {
                    srStmt.setStartEnd(true);
                    this.lexer.nextToken();
                    SQLExpr start = this.exprParser.expr();
                    srStmt.setStart(start);
                    this.accept(Token.END);
                    SQLExpr end = this.exprParser.expr();
                    srStmt.setEnd(end);
                    if (this.lexer.identifierEquals(FnvHash.Constants.EVERY)) {
                        this.lexer.nextToken();
                        SQLExpr every = this.exprParser.expr();
                        srStmt.setEvery(every);
                        this.accept(Token.RPAREN);
                    }
                }
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.DISTRIBUTED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            SQLExpr hash = this.exprParser.expr();
            srStmt.setDistributedBy(hash);
            if (this.lexer.identifierEquals(FnvHash.Constants.BUCKETS)) {
                this.lexer.nextToken();
                int bucket = this.lexer.integerValue().intValue();
                stmt.setBuckets(bucket);
                this.lexer.nextToken();
            }
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PROPERTIES)) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            srStmt.getStarRocksProperties().addAll(this.parseProperties(srStmt));
        }
    }

    @Override
    protected StarRocksCreateTableStatement newCreateStatement() {
        return new StarRocksCreateTableStatement();
    }

    public List<SQLExpr> parseProperties(SQLObject parent) {
        LinkedList<SQLExpr> starRocksProperties = new LinkedList<SQLExpr>();
        do {
            if (this.lexer.token() == Token.LBRACKET) {
                this.accept(Token.LBRACKET);
                SQLArrayExpr arrayExpr = new SQLArrayExpr();
                arrayExpr.setParent(parent);
                arrayExpr.getValues().add(this.exprParser.parseAssignItem(true, (SQLObject)arrayExpr));
                starRocksProperties.add(arrayExpr);
                if (this.lexer.token() == Token.COMMA) {
                    this.accept(Token.COMMA);
                }
                this.accept(Token.RBRACKET);
            } else {
                starRocksProperties.add(this.exprParser.parseAssignItem(true, parent));
            }
            if (this.lexer.token() != Token.COMMA) continue;
            this.accept(Token.COMMA);
        } while (this.lexer.token() != Token.RPAREN);
        this.accept(Token.RPAREN);
        return starRocksProperties;
    }
}

